import { Construct } from 'constructs';
import { UserPoolIdentityProviderProps } from './base';
import { UserPoolIdentityProviderBase } from './private/user-pool-idp-base';
/**
 * (experimental) Properties to initialize UserPoolAppleIdentityProvider.
 *
 * @experimental
 */
export interface UserPoolIdentityProviderAppleProps extends UserPoolIdentityProviderProps {
    /**
     * (experimental) The client id recognized by Apple APIs.
     *
     * @see https://developer.apple.com/documentation/sign_in_with_apple/clientconfigi/3230948-clientid
     * @experimental
     */
    readonly clientId: string;
    /**
     * (experimental) The teamId for Apple APIs to authenticate the client.
     *
     * @experimental
     */
    readonly teamId: string;
    /**
     * (experimental) The keyId (of the same key, which content has to be later supplied as `privateKey`) for Apple APIs to authenticate the client.
     *
     * @experimental
     */
    readonly keyId: string;
    /**
     * (experimental) The privateKey content for Apple APIs to authenticate the client.
     *
     * @experimental
     */
    readonly privateKey: string;
    /**
     * (experimental) The list of apple permissions to obtain for getting access to the apple profile.
     *
     * @default [ name ]
     * @see https://developer.apple.com/documentation/sign_in_with_apple/clientconfigi/3230955-scope
     * @experimental
     */
    readonly scopes?: string[];
}
/**
 * (experimental) Represents a identity provider that integrates with 'Apple'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class UserPoolIdentityProviderApple extends UserPoolIdentityProviderBase {
    /**
     * (experimental) The primary identifier of this identity provider.
     *
     * @experimental
     */
    readonly providerName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderAppleProps);
}
