import { Construct } from 'constructs';
import { UserPoolIdentityProviderProps } from './base';
import { UserPoolIdentityProviderBase } from './private/user-pool-idp-base';
/**
 * (experimental) Properties to initialize UserPoolAmazonIdentityProvider.
 *
 * @experimental
 */
export interface UserPoolIdentityProviderAmazonProps extends UserPoolIdentityProviderProps {
    /**
     * (experimental) The client id recognized by 'Login with Amazon' APIs.
     *
     * @see https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier
     * @experimental
     */
    readonly clientId: string;
    /**
     * (experimental) The client secret to be accompanied with clientId for 'Login with Amazon' APIs to authenticate the client.
     *
     * @see https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier
     * @experimental
     */
    readonly clientSecret: string;
    /**
     * (experimental) The types of user profile data to obtain for the Amazon profile.
     *
     * @default [ profile ]
     * @see https://developer.amazon.com/docs/login-with-amazon/customer-profile.html
     * @experimental
     */
    readonly scopes?: string[];
}
/**
 * (experimental) Represents a identity provider that integrates with 'Login with Amazon'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class UserPoolIdentityProviderAmazon extends UserPoolIdentityProviderBase {
    /**
     * (experimental) The primary identifier of this identity provider.
     *
     * @experimental
     */
    readonly providerName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderAmazonProps);
}
