import { IResource, Resource, Duration } from "../../core";
import { Construct } from 'constructs';
import { IUserPool } from './user-pool';
import { ClientAttributes } from './user-pool-attr';
import { IUserPoolResourceServer, ResourceServerScope } from './user-pool-resource-server';
/**
 * (experimental) Types of authentication flow.
 *
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html
 * @experimental
 */
export interface AuthFlow {
    /**
     * (experimental) Enable admin based user password authentication flow.
     *
     * @default false
     * @experimental
     */
    readonly adminUserPassword?: boolean;
    /**
     * (experimental) Enable custom authentication flow.
     *
     * @default false
     * @experimental
     */
    readonly custom?: boolean;
    /**
     * (experimental) Enable auth using username & password.
     *
     * @default false
     * @experimental
     */
    readonly userPassword?: boolean;
    /**
     * (experimental) Enable SRP based authentication.
     *
     * @default false
     * @experimental
     */
    readonly userSrp?: boolean;
}
/**
 * (experimental) OAuth settings to configure the interaction between the app and this client.
 *
 * @experimental
 */
export interface OAuthSettings {
    /**
     * (experimental) OAuth flows that are allowed with this client.
     *
     * @default {authorizationCodeGrant:true,implicitCodeGrant:true}
     * @see - the 'Allowed OAuth Flows' section at https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html
     * @experimental
     */
    readonly flows?: OAuthFlows;
    /**
     * (experimental) List of allowed redirect URLs for the identity providers.
     *
     * @default - ['https://example.com'] if either authorizationCodeGrant or implicitCodeGrant flows are enabled, no callback URLs otherwise.
     * @experimental
     */
    readonly callbackUrls?: string[];
    /**
     * (experimental) List of allowed logout URLs for the identity providers.
     *
     * @default - no logout URLs
     * @experimental
     */
    readonly logoutUrls?: string[];
    /**
     * (experimental) OAuth scopes that are allowed with this client.
     *
     * @default [OAuthScope.PHONE,OAuthScope.EMAIL,OAuthScope.OPENID,OAuthScope.PROFILE,OAuthScope.COGNITO_ADMIN]
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html
     * @experimental
     */
    readonly scopes?: OAuthScope[];
}
/**
 * (experimental) Types of OAuth grant flows.
 *
 * @see - the 'Allowed OAuth Flows' section at https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html
 * @experimental
 */
export interface OAuthFlows {
    /**
     * (experimental) Initiate an authorization code grant flow, which provides an authorization code as the response.
     *
     * @default false
     * @experimental
     */
    readonly authorizationCodeGrant?: boolean;
    /**
     * (experimental) The client should get the access token and ID token directly.
     *
     * @default false
     * @experimental
     */
    readonly implicitCodeGrant?: boolean;
    /**
     * (experimental) Client should get the access token and ID token from the token endpoint using a combination of client and client_secret.
     *
     * @default false
     * @experimental
     */
    readonly clientCredentials?: boolean;
}
/**
 * (experimental) OAuth scopes that are allowed with this client.
 *
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html
 * @experimental
 */
export declare class OAuthScope {
    /**
     * (experimental) Grants access to the 'phone_number' and 'phone_number_verified' claims.
     *
     * Automatically includes access to `OAuthScope.OPENID`.
     *
     * @experimental
     */
    static readonly PHONE: OAuthScope;
    /**
     * (experimental) Grants access to the 'email' and 'email_verified' claims.
     *
     * Automatically includes access to `OAuthScope.OPENID`.
     *
     * @experimental
     */
    static readonly EMAIL: OAuthScope;
    /**
     * (experimental) Returns all user attributes in the ID token that are readable by the client.
     *
     * @experimental
     */
    static readonly OPENID: OAuthScope;
    /**
     * (experimental) Grants access to all user attributes that are readable by the client Automatically includes access to `OAuthScope.OPENID`.
     *
     * @experimental
     */
    static readonly PROFILE: OAuthScope;
    /**
     * (experimental) Grants access to Amazon Cognito User Pool API operations that require access tokens, such as UpdateUserAttributes and VerifyUserAttribute.
     *
     * @experimental
     */
    static readonly COGNITO_ADMIN: OAuthScope;
    /**
     * (experimental) Custom scope is one that you define for your own resource server in the Resource Servers.
     *
     * The format is 'resource-server-identifier/scope'.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-define-resource-servers.html
     * @experimental
     */
    static custom(name: string): OAuthScope;
    /**
     * (experimental) Adds a custom scope that's tied to a resource server in your stack.
     *
     * @experimental
     */
    static resourceServer(server: IUserPoolResourceServer, scope: ResourceServerScope): OAuthScope;
    /**
     * (experimental) The name of this scope as recognized by CloudFormation.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthscopes
     * @experimental
     */
    readonly scopeName: string;
    private constructor();
}
/**
 * (experimental) Identity providers supported by the UserPoolClient.
 *
 * @experimental
 */
export declare class UserPoolClientIdentityProvider {
    /**
     * (experimental) Allow users to sign in using 'Sign In With Apple'.
     *
     * A `UserPoolIdentityProviderApple` must be attached to the user pool.
     *
     * @experimental
     */
    static readonly APPLE: UserPoolClientIdentityProvider;
    /**
     * (experimental) Allow users to sign in using 'Facebook Login'.
     *
     * A `UserPoolIdentityProviderFacebook` must be attached to the user pool.
     *
     * @experimental
     */
    static readonly FACEBOOK: UserPoolClientIdentityProvider;
    /**
     * (experimental) Allow users to sign in using 'Google Login'.
     *
     * A `UserPoolIdentityProviderGoogle` must be attached to the user pool.
     *
     * @experimental
     */
    static readonly GOOGLE: UserPoolClientIdentityProvider;
    /**
     * (experimental) Allow users to sign in using 'Login With Amazon'.
     *
     * A `UserPoolIdentityProviderAmazon` must be attached to the user pool.
     *
     * @experimental
     */
    static readonly AMAZON: UserPoolClientIdentityProvider;
    /**
     * (experimental) Allow users to sign in directly as a user of the User Pool.
     *
     * @experimental
     */
    static readonly COGNITO: UserPoolClientIdentityProvider;
    /**
     * (experimental) Specify a provider not yet supported by the CDK.
     *
     * @param name name of the identity provider as recognized by CloudFormation property `SupportedIdentityProviders`.
     * @experimental
     */
    static custom(name: string): UserPoolClientIdentityProvider;
    /**
     * (experimental) The name of the identity provider as recognized by CloudFormation property `SupportedIdentityProviders`.
     *
     * @experimental
     */
    readonly name: string;
    private constructor();
}
/**
 * (experimental) Options to create a UserPoolClient.
 *
 * @experimental
 */
export interface UserPoolClientOptions {
    /**
     * (experimental) Name of the application client.
     *
     * @default - cloudformation generated name
     * @experimental
     */
    readonly userPoolClientName?: string;
    /**
     * (experimental) Whether to generate a client secret.
     *
     * @default false
     * @experimental
     */
    readonly generateSecret?: boolean;
    /**
     * (experimental) The set of OAuth authentication flows to enable on the client.
     *
     * @default - all auth flows disabled
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html
     * @experimental
     */
    readonly authFlows?: AuthFlow;
    /**
     * (experimental) Turns off all OAuth interactions for this client.
     *
     * @default false
     * @experimental
     */
    readonly disableOAuth?: boolean;
    /**
     * (experimental) OAuth settings for this client to interact with the app.
     *
     * An error is thrown when this is specified and `disableOAuth` is set.
     *
     * @default - see defaults in `OAuthSettings`. meaningless if `disableOAuth` is set.
     * @experimental
     */
    readonly oAuth?: OAuthSettings;
    /**
     * (experimental) Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence.
     *
     * @default true for new stacks
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-managing-errors.html
     * @experimental
     */
    readonly preventUserExistenceErrors?: boolean;
    /**
     * (experimental) The list of identity providers that users should be able to use to sign in using this client.
     *
     * @default - supports all identity providers that are registered with the user pool. If the user pool and/or
     * identity providers are imported, either specify this option explicitly or ensure that the identity providers are
     * registered with the user pool using the `UserPool.registerIdentityProvider()` API.
     * @experimental
     */
    readonly supportedIdentityProviders?: UserPoolClientIdentityProvider[];
    /**
     * (experimental) Validity of the ID token.
     *
     * Values between 5 minutes and 1 day are valid. The duration can not be longer than the refresh token validity.
     *
     * @default Duration.minutes(60)
     * @see https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-id-token
     * @experimental
     */
    readonly idTokenValidity?: Duration;
    /**
     * (experimental) Validity of the refresh token.
     *
     * Values between 60 minutes and 10 years are valid.
     *
     * @default Duration.days(30)
     * @see https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-refresh-token
     * @experimental
     */
    readonly refreshTokenValidity?: Duration;
    /**
     * (experimental) Validity of the access token.
     *
     * Values between 5 minutes and 1 day are valid. The duration can not be longer than the refresh token validity.
     *
     * @default Duration.minutes(60)
     * @see https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-access-token
     * @experimental
     */
    readonly accessTokenValidity?: Duration;
    /**
     * (experimental) The set of attributes this client will be able to read.
     *
     * @default - all standard and custom attributes
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes
     * @experimental
     */
    readonly readAttributes?: ClientAttributes;
    /**
     * (experimental) The set of attributes this client will be able to write.
     *
     * @default - all standard and custom attributes
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes
     * @experimental
     */
    readonly writeAttributes?: ClientAttributes;
}
/**
 * (experimental) Properties for the UserPoolClient construct.
 *
 * @experimental
 */
export interface UserPoolClientProps extends UserPoolClientOptions {
    /**
     * (experimental) The UserPool resource this client will have access to.
     *
     * @experimental
     */
    readonly userPool: IUserPool;
}
/**
 * (experimental) Represents a Cognito user pool client.
 *
 * @experimental
 */
export interface IUserPoolClient extends IResource {
    /**
     * (experimental) Name of the application client.
     *
     * @experimental
     * @attribute true
     */
    readonly userPoolClientId: string;
}
/**
 * (experimental) Define a UserPool App Client.
 *
 * @experimental
 */
export declare class UserPoolClient extends Resource implements IUserPoolClient {
    /**
     * (experimental) Import a user pool client given its id.
     *
     * @experimental
     */
    static fromUserPoolClientId(scope: Construct, id: string, userPoolClientId: string): IUserPoolClient;
    /**
     * (experimental) Name of the application client.
     *
     * @experimental
     */
    readonly userPoolClientId: string;
    /**
     * (experimental) The OAuth flows enabled for this client.
     *
     * @experimental
     */
    readonly oAuthFlows: OAuthFlows;
    private readonly _userPoolClientName?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserPoolClientProps);
    /**
     * (experimental) The client name that was specified via the `userPoolClientName` property during initialization, throws an error otherwise.
     *
     * @experimental
     */
    get userPoolClientName(): string;
    private configureAuthFlows;
    private configureOAuthFlows;
    private configureOAuthScopes;
    private configurePreventUserExistenceErrors;
    private configureIdentityProviders;
    private configureTokenValidity;
    private validateDuration;
}
