"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientAttributes = exports.DateTimeAttribute = exports.BooleanAttribute = exports.NumberAttribute = exports.StringAttribute = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const attr_names_1 = require("./private/attr-names");
/**
 * (experimental) The String custom attribute type.
 *
 * @experimental
 */
class StringAttribute {
    /**
     * @experimental
     */
    constructor(props = {}) {
        if (props.minLen && !core_1.Token.isUnresolved(props.minLen) && props.minLen < 0) {
            throw new Error(`minLen cannot be less than 0 (value: ${props.minLen}).`);
        }
        if (props.maxLen && !core_1.Token.isUnresolved(props.maxLen) && props.maxLen > 2048) {
            throw new Error(`maxLen cannot be greater than 2048 (value: ${props.maxLen}).`);
        }
        this.minLen = props === null || props === void 0 ? void 0 : props.minLen;
        this.maxLen = props === null || props === void 0 ? void 0 : props.maxLen;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind() {
        let stringConstraints;
        if (this.minLen || this.maxLen) {
            stringConstraints = {
                minLen: this.minLen,
                maxLen: this.maxLen,
            };
        }
        return {
            dataType: 'String',
            stringConstraints,
            mutable: this.mutable,
        };
    }
}
exports.StringAttribute = StringAttribute;
_a = JSII_RTTI_SYMBOL_1;
StringAttribute[_a] = { fqn: "monocdk.aws_cognito.StringAttribute", version: "1.106.1" };
/**
 * (experimental) The Number custom attribute type.
 *
 * @experimental
 */
class NumberAttribute {
    /**
     * @experimental
     */
    constructor(props = {}) {
        this.min = props === null || props === void 0 ? void 0 : props.min;
        this.max = props === null || props === void 0 ? void 0 : props.max;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind() {
        let numberConstraints;
        if (this.min || this.max) {
            numberConstraints = {
                min: this.min,
                max: this.max,
            };
        }
        return {
            dataType: 'Number',
            numberConstraints,
            mutable: this.mutable,
        };
    }
}
exports.NumberAttribute = NumberAttribute;
_b = JSII_RTTI_SYMBOL_1;
NumberAttribute[_b] = { fqn: "monocdk.aws_cognito.NumberAttribute", version: "1.106.1" };
/**
 * (experimental) The Boolean custom attribute type.
 *
 * @experimental
 */
class BooleanAttribute {
    /**
     * @experimental
     */
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind() {
        return {
            dataType: 'Boolean',
            mutable: this.mutable,
        };
    }
}
exports.BooleanAttribute = BooleanAttribute;
_c = JSII_RTTI_SYMBOL_1;
BooleanAttribute[_c] = { fqn: "monocdk.aws_cognito.BooleanAttribute", version: "1.106.1" };
/**
 * (experimental) The DateTime custom attribute type.
 *
 * @experimental
 */
class DateTimeAttribute {
    /**
     * @experimental
     */
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind() {
        return {
            dataType: 'DateTime',
            mutable: this.mutable,
        };
    }
}
exports.DateTimeAttribute = DateTimeAttribute;
_d = JSII_RTTI_SYMBOL_1;
DateTimeAttribute[_d] = { fqn: "monocdk.aws_cognito.DateTimeAttribute", version: "1.106.1" };
/**
 * (experimental) A set of attributes, useful to set Read and Write attributes.
 *
 * @experimental
 */
class ClientAttributes {
    /**
     * (experimental) Creates a ClientAttributes with the specified attributes.
     *
     * @default - a ClientAttributes object without any attributes
     * @experimental
     */
    constructor() {
        this.attributesSet = new Set();
    }
    /**
     * (experimental) Creates a custom ClientAttributes with the specified attributes.
     *
     * @param attributes a list of standard attributes to add to the set.
     * @experimental
     */
    withStandardAttributes(attributes) {
        let attributesSet = new Set(this.attributesSet);
        // iterate through key-values in the `StandardAttributeNames` constant
        // to get the value for all attributes
        for (const attributeKey in attr_names_1.StandardAttributeNames) {
            if (attributes[attributeKey] === true) {
                const attributeName = attr_names_1.StandardAttributeNames[attributeKey];
                attributesSet.add(attributeName);
            }
        }
        let aux = new ClientAttributes();
        aux.attributesSet = attributesSet;
        return aux;
    }
    /**
     * (experimental) Creates a custom ClientAttributes with the specified attributes.
     *
     * @param attributes a list of custom attributes to add to the set.
     * @experimental
     */
    withCustomAttributes(...attributes) {
        let attributesSet = new Set(this.attributesSet);
        for (let attribute of attributes) {
            // custom attributes MUST begin with `custom:`, so add the string if not present
            if (!attribute.startsWith('custom:')) {
                attribute = 'custom:' + attribute;
            }
            attributesSet.add(attribute);
        }
        let aux = new ClientAttributes();
        aux.attributesSet = attributesSet;
        return aux;
    }
    /**
     * (experimental) The list of attributes represented by this ClientAttributes.
     *
     * @experimental
     */
    attributes() {
        // sorting is unnecessary but it simplify testing
        return Array.from(this.attributesSet).sort();
    }
}
exports.ClientAttributes = ClientAttributes;
_e = JSII_RTTI_SYMBOL_1;
ClientAttributes[_e] = { fqn: "monocdk.aws_cognito.ClientAttributes", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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