"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FullActionDescriptor = void 0;
/**
 * This class is private to the aws-codepipeline package.
 */
class FullActionDescriptor {
    constructor(props) {
        var _a, _b;
        this.action = props.action;
        const actionProperties = props.action.actionProperties;
        this.actionName = actionProperties.actionName;
        this.category = actionProperties.category;
        this.owner = actionProperties.owner || 'AWS';
        this.provider = actionProperties.provider;
        this.version = actionProperties.version || '1';
        this.runOrder = (_a = actionProperties.runOrder) !== null && _a !== void 0 ? _a : 1;
        this.artifactBounds = actionProperties.artifactBounds;
        this.namespace = actionProperties.variablesNamespace;
        this.inputs = deduplicateArtifacts(actionProperties.inputs);
        this.outputs = deduplicateArtifacts(actionProperties.outputs);
        this.region = props.actionRegion || actionProperties.region;
        this.role = (_b = actionProperties.role) !== null && _b !== void 0 ? _b : props.actionRole;
        this.configuration = props.actionConfig.configuration;
    }
}
exports.FullActionDescriptor = FullActionDescriptor;
function deduplicateArtifacts(artifacts) {
    const ret = new Array();
    for (const artifact of artifacts || []) {
        if (artifact.artifactName) {
            if (ret.find(a => a.artifactName === artifact.artifactName)) {
                continue;
            }
        }
        else {
            if (ret.find(a => a === artifact)) {
                continue;
            }
        }
        ret.push(artifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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