"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactPath = exports.Artifact = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const validation = require("./private/validation");
/**
 * (experimental) An output artifact of an action.
 *
 * Artifacts can be used as input by some actions.
 *
 * @experimental
 */
class Artifact {
    /**
     * @experimental
     */
    constructor(artifactName) {
        this.metadata = {};
        validation.validateArtifactName(artifactName);
        this._artifactName = artifactName;
    }
    /**
     * (experimental) A static factory method used to create instances of the Artifact class.
     *
     * Mainly meant to be used from `decdk`.
     *
     * @param name the (required) name of the Artifact.
     * @experimental
     */
    static artifact(name) {
        return new Artifact(name);
    }
    /**
     * @experimental
     */
    get artifactName() {
        return this._artifactName;
    }
    /**
     * (experimental) Returns an ArtifactPath for a file within this artifact.
     *
     * CfnOutput is in the form "<artifact-name>::<file-name>"
     *
     * @param fileName The name of the file.
     * @experimental
     */
    atPath(fileName) {
        return new ArtifactPath(this, fileName);
    }
    /**
     * (experimental) The artifact attribute for the name of the S3 bucket where the artifact is stored.
     *
     * @experimental
     */
    get bucketName() {
        return artifactAttribute(this, 'BucketName');
    }
    /**
     * (experimental) The artifact attribute for The name of the .zip file that contains the artifact that is generated by AWS CodePipeline, such as 1ABCyZZ.zip.
     *
     * @experimental
     */
    get objectKey() {
        return artifactAttribute(this, 'ObjectKey');
    }
    /**
     * (experimental) The artifact attribute of the Amazon Simple Storage Service (Amazon S3) URL of the artifact, such as https://s3-us-west-2.amazonaws.com/artifactstorebucket-yivczw8jma0c/test/TemplateSo/1ABCyZZ.zip.
     *
     * @experimental
     */
    get url() {
        return artifactAttribute(this, 'URL');
    }
    /**
     * (experimental) Returns a token for a value inside a JSON file within this artifact.
     *
     * @param jsonFile The JSON file name.
     * @param keyName The hash key.
     * @experimental
     */
    getParam(jsonFile, keyName) {
        return artifactGetParam(this, jsonFile, keyName);
    }
    /**
     * (experimental) Returns the location of the .zip file in S3 that this Artifact represents. Used by Lambda's `CfnParametersCode` when being deployed in a CodePipeline.
     *
     * @experimental
     */
    get s3Location() {
        return {
            bucketName: this.bucketName,
            objectKey: this.objectKey,
        };
    }
    /**
     * (experimental) Add arbitrary extra payload to the artifact under a given key.
     *
     * This can be used by CodePipeline actions to communicate data between themselves.
     * If metadata was already present under the given key,
     * it will be overwritten with the new value.
     *
     * @experimental
     */
    setMetadata(key, value) {
        this.metadata[key] = value;
    }
    /**
     * (experimental) Retrieve the metadata stored in this artifact under the given key.
     *
     * If there is no metadata stored under the given key,
     * null will be returned.
     *
     * @experimental
     */
    getMetadata(key) {
        return this.metadata[key];
    }
    /**
     * @experimental
     */
    toString() {
        return this.artifactName;
    }
    /** @internal */
    _setName(name) {
        if (this._artifactName) {
            throw new Error(`Artifact already has name '${this._artifactName}', cannot override it`);
        }
        else {
            this._artifactName = name;
        }
    }
}
exports.Artifact = Artifact;
_a = JSII_RTTI_SYMBOL_1;
Artifact[_a] = { fqn: "monocdk.aws_codepipeline.Artifact", version: "1.106.1" };
/**
 * (experimental) A specific file within an output artifact.
 *
 * The most common use case for this is specifying the template file
 * for a CloudFormation action.
 *
 * @experimental
 */
class ArtifactPath {
    /**
     * @experimental
     */
    constructor(artifact, fileName) {
        this.artifact = artifact;
        this.fileName = fileName;
    }
    /**
     * @experimental
     */
    static artifactPath(artifactName, fileName) {
        return new ArtifactPath(Artifact.artifact(artifactName), fileName);
    }
    /**
     * @experimental
     */
    get location() {
        const artifactName = this.artifact.artifactName
            ? this.artifact.artifactName
            : core_1.Lazy.string({ produce: () => this.artifact.artifactName });
        return `${artifactName}::${this.fileName}`;
    }
}
exports.ArtifactPath = ArtifactPath;
_b = JSII_RTTI_SYMBOL_1;
ArtifactPath[_b] = { fqn: "monocdk.aws_codepipeline.ArtifactPath", version: "1.106.1" };
function artifactAttribute(artifact, attributeName) {
    const lazyArtifactName = core_1.Lazy.string({ produce: () => artifact.artifactName });
    return core_1.Token.asString({ 'Fn::GetArtifactAtt': [lazyArtifactName, attributeName] });
}
function artifactGetParam(artifact, jsonFile, keyName) {
    const lazyArtifactName = core_1.Lazy.string({ produce: () => artifact.artifactName });
    return core_1.Token.asString({ 'Fn::GetParam': [lazyArtifactName, jsonFile, keyName] });
}
//# sourceMappingURL=data:application/json;base64,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