import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import * as s3 from "../../aws-s3";
import { IResource } from "../../core";
import { Artifact } from './artifact';
import { Construct } from "../../core";
/**
 * @experimental
 */
export declare enum ActionCategory {
    /**
     * @experimental
     */
    SOURCE = "Source",
    /**
     * @experimental
     */
    BUILD = "Build",
    /**
     * @experimental
     */
    TEST = "Test",
    /**
     * @experimental
     */
    APPROVAL = "Approval",
    /**
     * @experimental
     */
    DEPLOY = "Deploy",
    /**
     * @experimental
     */
    INVOKE = "Invoke"
}
/**
 * (experimental) Specifies the constraints on the number of input and output artifacts an action can have.
 *
 * The constraints for each action type are documented on the
 * {@link https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html Pipeline Structure Reference} page.
 *
 * @experimental
 */
export interface ActionArtifactBounds {
    /**
     * @experimental
     */
    readonly minInputs: number;
    /**
     * @experimental
     */
    readonly maxInputs: number;
    /**
     * @experimental
     */
    readonly minOutputs: number;
    /**
     * @experimental
     */
    readonly maxOutputs: number;
}
/**
 * (experimental) The CodePipeline variables that are global, not bound to a specific action.
 *
 * This class defines a bunch of static fields that represent the different variables.
 * These can be used can be used in any action configuration.
 *
 * @experimental
 */
export declare class GlobalVariables {
    /**
     * (experimental) The identifier of the current pipeline execution.
     *
     * @experimental
     */
    static readonly executionId = "#{codepipeline.PipelineExecutionId}";
}
/**
 * @experimental
 */
export interface ActionProperties {
    /**
     * @experimental
     */
    readonly actionName: string;
    /**
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The AWS region the given Action resides in.
     *
     * Note that a cross-region Pipeline requires replication buckets to function correctly.
     * You can provide their names with the {@link PipelineProps#crossRegionReplicationBuckets} property.
     * If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
     * that you will need to `cdk deploy` before deploying the main, Pipeline-containing Stack.
     *
     * @default the Action resides in the same region as the Pipeline
     * @experimental
     */
    readonly region?: string;
    /**
     * (experimental) The account the Action is supposed to live in.
     *
     * For Actions backed by resources,
     * this is inferred from the Stack {@link resource} is part of.
     * However, some Actions, like the CloudFormation ones,
     * are not backed by any resource, and they still might want to be cross-account.
     * In general, a concrete Action class should specify either {@link resource},
     * or {@link account} - but not both.
     *
     * @experimental
     */
    readonly account?: string;
    /**
     * (experimental) The optional resource that is backing this Action.
     *
     * This is used for automatically handling Actions backed by
     * resources from a different account and/or region.
     *
     * @experimental
     */
    readonly resource?: IResource;
    /**
     * (experimental) The category of the action.
     *
     * The category defines which action type the owner
     * (the entity that performs the action) performs.
     *
     * @experimental
     */
    readonly category: ActionCategory;
    /**
     * (experimental) The service provider that the action calls.
     *
     * @experimental
     */
    readonly provider: string;
    /**
     * @experimental
     */
    readonly owner?: string;
    /**
     * @experimental
     */
    readonly version?: string;
    /**
     * (experimental) The order in which AWS CodePipeline runs this action. For more information, see the AWS CodePipeline User Guide.
     *
     * https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     *
     * @experimental
     */
    readonly runOrder?: number;
    /**
     * @experimental
     */
    readonly artifactBounds: ActionArtifactBounds;
    /**
     * @experimental
     */
    readonly inputs?: Artifact[];
    /**
     * @experimental
     */
    readonly outputs?: Artifact[];
    /**
     * (experimental) The name of the namespace to use for variables emitted by this action.
     *
     * @default - a name will be generated, based on the stage and action names
     * @experimental
     */
    readonly variablesNamespace?: string;
}
/**
 * @experimental
 */
export interface ActionBindOptions {
    /**
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * @experimental
     */
    readonly bucket: s3.IBucket;
}
/**
 * @experimental
 */
export interface ActionConfig {
    /**
     * @experimental
     */
    readonly configuration?: any;
}
/**
 * (experimental) A Pipeline Action.
 *
 * If you want to implement this interface,
 * consider extending the {@link Action} class,
 * which contains some common logic.
 *
 * @experimental
 */
export interface IAction {
    /**
     * (experimental) The simple properties of the Action, like its Owner, name, etc.
     *
     * Note that this accessor will be called before the {@link bind} callback.
     *
     * @experimental
     */
    readonly actionProperties: ActionProperties;
    /**
     * (experimental) The callback invoked when this Action is added to a Pipeline.
     *
     * @param scope the Construct tree scope the Action can use if it needs to create any resources.
     * @param stage the {@link IStage} this Action is being added to.
     * @param options additional options the Action can use, like the artifact Bucket of the pipeline it's being added to.
     * @experimental
     */
    bind(scope: Construct, stage: IStage, options: ActionBindOptions): ActionConfig;
    /**
     * (experimental) Creates an Event that will be triggered whenever the state of this Action changes.
     *
     * @param name the name to use for the new Event.
     * @param target the optional target for the Event.
     * @param options additional options that can be used to customize the created Event.
     * @experimental
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
}
/**
 * (experimental) The abstract view of an AWS CodePipeline as required and used by Actions.
 *
 * It extends {@link events.IRuleTarget},
 * so this interface can be used as a Target for CloudWatch Events.
 *
 * @experimental
 */
export interface IPipeline extends IResource {
    /**
     * (experimental) The name of the Pipeline.
     *
     * @experimental
     * @attribute true
     */
    readonly pipelineName: string;
    /**
     * (experimental) The ARN of the Pipeline.
     *
     * @experimental
     * @attribute true
     */
    readonly pipelineArn: string;
    /**
     * (experimental) Define an event rule triggered by this CodePipeline.
     *
     * @param id Identifier for this event handler.
     * @param options Additional options to pass to the event rule.
     * @experimental
     */
    onEvent(id: string, options?: events.OnEventOptions): events.Rule;
    /**
     * (experimental) Define an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
     *
     * @param id Identifier for this event handler.
     * @param options Additional options to pass to the event rule.
     * @experimental
     */
    onStateChange(id: string, options?: events.OnEventOptions): events.Rule;
}
/**
 * (experimental) The abstract interface of a Pipeline Stage that is used by Actions.
 *
 * @experimental
 */
export interface IStage {
    /**
     * (experimental) The physical, human-readable name of this Pipeline Stage.
     *
     * @experimental
     */
    readonly stageName: string;
    /**
     * @experimental
     */
    readonly pipeline: IPipeline;
    /**
     * (experimental) The actions belonging to this stage.
     *
     * @experimental
     */
    readonly actions: IAction[];
    /**
     * @experimental
     */
    addAction(action: IAction): void;
    /**
     * @experimental
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
}
/**
 * (experimental) Common properties shared by all Actions.
 *
 * @experimental
 */
export interface CommonActionProps {
    /**
     * (experimental) The physical, human-readable name of the Action.
     *
     * Note that Action names must be unique within a single Stage.
     *
     * @experimental
     */
    readonly actionName: string;
    /**
     * (experimental) The runOrder property for this Action.
     *
     * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
     *
     * @default 1
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
     * @experimental
     */
    readonly runOrder?: number;
    /**
     * (experimental) The name of the namespace to use for variables emitted by this action.
     *
     * @default - a name will be generated, based on the stage and action names,
     * if any of the action's variables were referenced - otherwise,
     * no namespace will be set
     * @experimental
     */
    readonly variablesNamespace?: string;
}
/**
 * (experimental) Common properties shared by all Actions whose {@link ActionProperties.owner} field is 'AWS' (or unset, as 'AWS' is the default).
 *
 * @experimental
 */
export interface CommonAwsActionProps extends CommonActionProps {
    /**
     * (experimental) The Role in which context's this Action will be executing in.
     *
     * The Pipeline's Role will assume this Role
     * (the required permissions for that will be granted automatically)
     * right before executing this Action.
     * This Action will be passed into your {@link IAction.bind}
     * method in the {@link ActionBindOptions.role} property.
     *
     * @default a new Role will be generated
     * @experimental
     */
    readonly role?: iam.IRole;
}
/**
 * (experimental) Low-level class for generic CodePipeline Actions implementing the {@link IAction} interface.
 *
 * Contains some common logic that can be re-used by all {@link IAction} implementations.
 * If you're writing your own Action class,
 * feel free to extend this class.
 *
 * @experimental
 */
export declare abstract class Action implements IAction {
    /**
     * (experimental) This is a renamed version of the {@link IAction.actionProperties} property.
     *
     * @experimental
     */
    protected abstract readonly providedActionProperties: ActionProperties;
    private __actionProperties?;
    private __pipeline?;
    private __stage?;
    private __scope?;
    private readonly _namespaceToken;
    private _customerProvidedNamespace?;
    private _actualNamespace?;
    private _variableReferenced;
    /**
     * @experimental
     */
    protected constructor();
    /**
     * (experimental) The simple properties of the Action, like its Owner, name, etc.
     *
     * Note that this accessor will be called before the {@link bind} callback.
     *
     * @experimental
     */
    get actionProperties(): ActionProperties;
    /**
     * (experimental) The callback invoked when this Action is added to a Pipeline.
     *
     * @experimental
     */
    bind(scope: Construct, stage: IStage, options: ActionBindOptions): ActionConfig;
    /**
     * (experimental) Creates an Event that will be triggered whenever the state of this Action changes.
     *
     * @experimental
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    /**
     * @experimental
     */
    protected variableExpression(variableName: string): string;
    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     *
     * @experimental
     */
    protected abstract bound(scope: Construct, stage: IStage, options: ActionBindOptions): ActionConfig;
    private get _pipeline();
    private get _stage();
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    private get _scope();
}
