import * as codepipeline from "../../../aws-codepipeline";
import { Action } from '../action';
import { Construct } from "../../../core";
/**
 * (experimental) Construction properties of the {@link ServiceCatalogDeployActionBeta1 ServiceCatalog deploy CodePipeline Action}.
 *
 * @experimental
 */
export interface ServiceCatalogDeployActionBeta1Props extends codepipeline.CommonAwsActionProps {
    /**
     * (experimental) The path to the cloudformation artifact.
     *
     * @experimental
     */
    readonly templatePath: codepipeline.ArtifactPath;
    /**
     * (experimental) The name of the version of the Service Catalog product to be deployed.
     *
     * @experimental
     */
    readonly productVersionName: string;
    /**
     * (experimental) The optional description of this version of the Service Catalog product.
     *
     * @default ''
     * @experimental
     */
    readonly productVersionDescription?: string;
    /**
     * (experimental) The identifier of the product in the Service Catalog.
     *
     * This product must already exist.
     *
     * @experimental
     */
    readonly productId: string;
}
/**
 * (experimental) CodePipeline action to connect to an existing ServiceCatalog product. <<<<<<< HEAD:packages/@aws-cdk/aws-codepipeline-actions/lib/servicecatalog/deploy-action.ts.
 *
 * **Note**: this class is still experimental, and may have breaking changes in the future!
 *
 * =======
 * >>>>>>> master:packages/@aws-cdk/aws-codepipeline-actions/lib/servicecatalog/deploy-action-beta1.ts
 *
 * @experimental
 */
export declare class ServiceCatalogDeployActionBeta1 extends Action {
    private readonly templatePath;
    private readonly productVersionName;
    private readonly productVersionDescription?;
    private readonly productId;
    private readonly productType;
    /**
     * @experimental
     */
    constructor(props: ServiceCatalogDeployActionBeta1Props);
    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     *
     * @experimental
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
