import * as codepipeline from "../../../aws-codepipeline";
import * as s3 from "../../../aws-s3";
import { Action } from '../action';
import { Construct } from "../../../core";
/**
 * (experimental) How should the S3 Action detect changes.
 *
 * This is the type of the {@link S3SourceAction.trigger} property.
 *
 * @experimental
 */
export declare enum S3Trigger {
    /**
     * (experimental) The Action will never detect changes - the Pipeline it's part of will only begin a run when explicitly started.
     *
     * @experimental
     */
    NONE = "None",
    /**
     * (experimental) CodePipeline will poll S3 to detect changes.
     *
     * This is the default method of detecting changes.
     *
     * @experimental
     */
    POLL = "Poll",
    /**
     * (experimental) CodePipeline will use CloudWatch Events to be notified of changes.
     *
     * Note that the Bucket that the Action uses needs to be part of a CloudTrail Trail
     * for the events to be delivered.
     *
     * @experimental
     */
    EVENTS = "Events"
}
/**
 * (experimental) The CodePipeline variables emitted by the S3 source Action.
 *
 * @experimental
 */
export interface S3SourceVariables {
    /**
     * (experimental) The identifier of the S3 version of the object that triggered the build.
     *
     * @experimental
     */
    readonly versionId: string;
    /**
     * (experimental) The e-tag of the S3 version of the object that triggered the build.
     *
     * @experimental
     */
    readonly eTag: string;
}
/**
 * (experimental) Construction properties of the {@link S3SourceAction S3 source Action}.
 *
 * @experimental
 */
export interface S3SourceActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * @experimental
     */
    readonly output: codepipeline.Artifact;
    /**
     * (experimental) The key within the S3 bucket that stores the source code.
     *
     * @experimental
     * @example
     *
     * 'path/to/file.zip'
     */
    readonly bucketKey: string;
    /**
     * (experimental) How should CodePipeline detect source changes for this Action.
     *
     * Note that if this is S3Trigger.EVENTS, you need to make sure to include the source Bucket in a CloudTrail Trail,
     * as otherwise the CloudWatch Events will not be emitted.
     *
     * @default S3Trigger.POLL
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html
     * @experimental
     */
    readonly trigger?: S3Trigger;
    /**
     * (experimental) The Amazon S3 bucket that stores the source code.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
}
/**
 * (experimental) Source that is provided by a specific Amazon S3 object.
 *
 * Will trigger the pipeline as soon as the S3 object changes, but only if there is
 * a CloudTrail Trail in the account that captures the S3 event.
 *
 * @experimental
 */
export declare class S3SourceAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: S3SourceActionProps);
    /**
     * (experimental) The variables emitted by this action.
     *
     * @experimental
     */
    get variables(): S3SourceVariables;
    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     *
     * @experimental
     */
    protected bound(_scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    private generateEventId;
}
