"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManualApprovalAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
const subs = require("../../aws-sns-subscriptions"); // Automatically re-written from '@aws-cdk/aws-sns-subscriptions'
const action_1 = require("./action");
/**
 * (experimental) Manual approval action.
 *
 * @experimental
 */
class ManualApprovalAction extends action_1.Action {
    /**
     * @experimental
     */
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 0, maxOutputs: 0 },
        });
        this.props = props;
    }
    /**
     * @experimental
     */
    get notificationTopic() {
        return this._notificationTopic;
    }
    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     *
     * @experimental
     */
    bound(scope, _stage, options) {
        var _b;
        if (this.props.notificationTopic) {
            this._notificationTopic = this.props.notificationTopic;
        }
        else if ((this.props.notifyEmails || []).length > 0) {
            this._notificationTopic = new sns.Topic(scope, 'TopicResource');
        }
        if (this._notificationTopic) {
            this._notificationTopic.grantPublish(options.role);
            for (const notifyEmail of this.props.notifyEmails || []) {
                this._notificationTopic.addSubscription(new subs.EmailSubscription(notifyEmail));
            }
        }
        return {
            configuration: undefinedIfAllValuesAreEmpty({
                NotificationArn: (_b = this._notificationTopic) === null || _b === void 0 ? void 0 : _b.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            }),
        };
    }
}
exports.ManualApprovalAction = ManualApprovalAction;
_a = JSII_RTTI_SYMBOL_1;
ManualApprovalAction[_a] = { fqn: "monocdk.aws_codepipeline_actions.ManualApprovalAction", version: "1.106.1" };
function undefinedIfAllValuesAreEmpty(object) {
    return Object.values(object).some(v => v !== undefined) ? object : undefined;
}
//# sourceMappingURL=data:application/json;base64,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