import * as codepipeline from "../../../aws-codepipeline";
import { Action } from '../action';
import { IJenkinsProvider } from './jenkins-provider';
import { Construct } from "../../../core";
/**
 * (experimental) The type of the Jenkins Action that determines its CodePipeline Category - Build, or Test.
 *
 * Note that a Jenkins provider, even if it has the same name,
 * must be separately registered for each type.
 *
 * @experimental
 */
export declare enum JenkinsActionType {
    /**
     * (experimental) The Action will have the Build Category.
     *
     * @experimental
     */
    BUILD = 0,
    /**
     * (experimental) The Action will have the Test Category.
     *
     * @experimental
     */
    TEST = 1
}
/**
 * (experimental) Construction properties of {@link JenkinsAction}.
 *
 * @experimental
 */
export interface JenkinsActionProps extends codepipeline.CommonActionProps {
    /**
     * (experimental) The source to use as input for this build.
     *
     * @experimental
     */
    readonly inputs?: codepipeline.Artifact[];
    /**
     * @experimental
     */
    readonly outputs?: codepipeline.Artifact[];
    /**
     * (experimental) The Jenkins Provider for this Action.
     *
     * @experimental
     */
    readonly jenkinsProvider: IJenkinsProvider;
    /**
     * (experimental) The name of the project (sometimes also called job, or task) on your Jenkins installation that will be invoked by this Action.
     *
     * @experimental
     * @example
     *
     * 'MyJob'
     */
    readonly projectName: string;
    /**
     * (experimental) The type of the Action - Build, or Test.
     *
     * @experimental
     */
    readonly type: JenkinsActionType;
}
/**
 * (experimental) Jenkins build CodePipeline Action.
 *
 * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-four-stage-pipeline.html
 * @experimental
 */
export declare class JenkinsAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: JenkinsActionProps);
    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     *
     * @experimental
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, _options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
