import * as codepipeline from "../../../aws-codepipeline";
import * as ecs from "../../../aws-ecs";
import { Duration } from "../../../core";
import { Action } from '../action';
import { Construct } from "../../../core";
/**
 * (experimental) Construction properties of {@link EcsDeployAction}.
 *
 * @experimental
 */
export interface EcsDeployActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * (experimental) The input artifact that contains the JSON image definitions file to use for deployments.
     *
     * The JSON file is a list of objects,
     * each with 2 keys: `name` is the name of the container in the Task Definition,
     * and `imageUri` is the Docker image URI you want to update your service with.
     * If you use this property, it's assumed the file is called 'imagedefinitions.json'.
     * If your build uses a different file, leave this property empty,
     * and use the `imageFile` property instead.
     *
     * @default - one of this property, or `imageFile`, is required
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-create.html#pipelines-create-image-definitions
     * @experimental
     */
    readonly input?: codepipeline.Artifact;
    /**
     * (experimental) The name of the JSON image definitions file to use for deployments.
     *
     * The JSON file is a list of objects,
     * each with 2 keys: `name` is the name of the container in the Task Definition,
     * and `imageUri` is the Docker image URI you want to update your service with.
     * Use this property if you want to use a different name for this file than the default 'imagedefinitions.json'.
     * If you use this property, you don't need to specify the `input` property.
     *
     * @default - one of this property, or `input`, is required
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-create.html#pipelines-create-image-definitions
     * @experimental
     */
    readonly imageFile?: codepipeline.ArtifactPath;
    /**
     * (experimental) The ECS Service to deploy.
     *
     * @experimental
     */
    readonly service: ecs.IBaseService;
    /**
     * (experimental) Timeout for the ECS deployment in minutes.
     *
     * Value must be between 1-60.
     *
     * @default - 60 minutes
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-ECS.html
     * @experimental
     */
    readonly deploymentTimeout?: Duration;
}
/**
 * (experimental) CodePipeline Action to deploy an ECS Service.
 *
 * @experimental
 */
export declare class EcsDeployAction extends Action {
    private readonly props;
    private readonly deploymentTimeout?;
    /**
     * @experimental
     */
    constructor(props: EcsDeployActionProps);
    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     *
     * @experimental
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
