import * as codepipeline from "../../../aws-codepipeline";
import * as ecr from "../../../aws-ecr";
import { Action } from '../action';
import { Construct } from "../../../core";
/**
 * (experimental) The CodePipeline variables emitted by the ECR source Action.
 *
 * @experimental
 */
export interface EcrSourceVariables {
    /**
     * (experimental) The identifier of the registry.
     *
     * In ECR, this is usually the ID of the AWS account owning it.
     *
     * @experimental
     */
    readonly registryId: string;
    /**
     * (experimental) The physical name of the repository that this action tracks.
     *
     * @experimental
     */
    readonly repositoryName: string;
    /**
     * (experimental) The digest of the current image, in the form '<digest type>:<digest value>'.
     *
     * @experimental
     */
    readonly imageDigest: string;
    /**
     * (experimental) The Docker tag of the current image.
     *
     * @experimental
     */
    readonly imageTag: string;
    /**
     * (experimental) The full ECR Docker URI of the current image.
     *
     * @experimental
     */
    readonly imageUri: string;
}
/**
 * (experimental) Construction properties of {@link EcrSourceAction}.
 *
 * @experimental
 */
export interface EcrSourceActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * (experimental) The image tag that will be checked for changes.
     *
     * @default 'latest'
     * @experimental
     */
    readonly imageTag?: string;
    /**
     * @experimental
     */
    readonly output: codepipeline.Artifact;
    /**
     * (experimental) The repository that will be watched for changes.
     *
     * @experimental
     */
    readonly repository: ecr.IRepository;
}
/**
 * (experimental) The ECR Repository source CodePipeline Action.
 *
 * Will trigger the pipeline as soon as the target tag in the repository
 * changes, but only if there is a CloudTrail Trail in the account that
 * captures the ECR event.
 *
 * @experimental
 */
export declare class EcrSourceAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: EcrSourceActionProps);
    /**
     * (experimental) The variables emitted by this action.
     *
     * @experimental
     */
    get variables(): EcrSourceVariables;
    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     *
     * @experimental
     */
    protected bound(_scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
