"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomActionRegistration = void 0;
const codepipeline = require("../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends core_1.Construct {
    constructor(parent, id, props) {
        var _a;
        super(parent, id);
        new codepipeline.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: (_a = props.actionProperties) === null || _a === void 0 ? void 0 : _a.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
exports.CustomActionRegistration = CustomActionRegistration;
//# sourceMappingURL=data:application/json;base64,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