"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deployArtifactBounds = exports.sourceArtifactBounds = void 0;
/**
 * The ArtifactBounds that make sense for source Actions -
 * they don't have any inputs, and have exactly one output.
 */
function sourceArtifactBounds() {
    return {
        minInputs: 0,
        maxInputs: 0,
        minOutputs: 1,
        maxOutputs: 1,
    };
}
exports.sourceArtifactBounds = sourceArtifactBounds;
/**
 * The ArtifactBounds that make sense for deploy Actions -
 * they have exactly one input, and don't produce any outputs.
 */
function deployArtifactBounds() {
    return {
        minInputs: 1,
        maxInputs: 1,
        minOutputs: 0,
        maxOutputs: 0,
    };
}
exports.deployArtifactBounds = deployArtifactBounds;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tbW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBOzs7R0FHRztBQUNILFNBQWdCLG9CQUFvQjtJQUNoQyxPQUFPO1FBQ0gsU0FBUyxFQUFFLENBQUM7UUFDWixTQUFTLEVBQUUsQ0FBQztRQUNaLFVBQVUsRUFBRSxDQUFDO1FBQ2IsVUFBVSxFQUFFLENBQUM7S0FDaEIsQ0FBQztBQUNOLENBQUM7QUFQRCxvREFPQztBQUNEOzs7R0FHRztBQUNILFNBQWdCLG9CQUFvQjtJQUNoQyxPQUFPO1FBQ0gsU0FBUyxFQUFFLENBQUM7UUFDWixTQUFTLEVBQUUsQ0FBQztRQUNaLFVBQVUsRUFBRSxDQUFDO1FBQ2IsVUFBVSxFQUFFLENBQUM7S0FDaEIsQ0FBQztBQUNOLENBQUM7QUFQRCxvREFPQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNvZGVwaXBlbGluZSBmcm9tIFwiLi4vLi4vYXdzLWNvZGVwaXBlbGluZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVwaXBlbGluZSdcbi8qKlxuICogVGhlIEFydGlmYWN0Qm91bmRzIHRoYXQgbWFrZSBzZW5zZSBmb3Igc291cmNlIEFjdGlvbnMgLVxuICogdGhleSBkb24ndCBoYXZlIGFueSBpbnB1dHMsIGFuZCBoYXZlIGV4YWN0bHkgb25lIG91dHB1dC5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHNvdXJjZUFydGlmYWN0Qm91bmRzKCk6IGNvZGVwaXBlbGluZS5BY3Rpb25BcnRpZmFjdEJvdW5kcyB7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgbWluSW5wdXRzOiAwLFxuICAgICAgICBtYXhJbnB1dHM6IDAsXG4gICAgICAgIG1pbk91dHB1dHM6IDEsXG4gICAgICAgIG1heE91dHB1dHM6IDEsXG4gICAgfTtcbn1cbi8qKlxuICogVGhlIEFydGlmYWN0Qm91bmRzIHRoYXQgbWFrZSBzZW5zZSBmb3IgZGVwbG95IEFjdGlvbnMgLVxuICogdGhleSBoYXZlIGV4YWN0bHkgb25lIGlucHV0LCBhbmQgZG9uJ3QgcHJvZHVjZSBhbnkgb3V0cHV0cy5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGRlcGxveUFydGlmYWN0Qm91bmRzKCk6IGNvZGVwaXBlbGluZS5BY3Rpb25BcnRpZmFjdEJvdW5kcyB7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgbWluSW5wdXRzOiAxLFxuICAgICAgICBtYXhJbnB1dHM6IDEsXG4gICAgICAgIG1pbk91dHB1dHM6IDAsXG4gICAgICAgIG1heE91dHB1dHM6IDAsXG4gICAgfTtcbn1cbiJdfQ==