import * as codecommit from "../../../aws-codecommit";
import * as codepipeline from "../../../aws-codepipeline";
import * as iam from "../../../aws-iam";
import { Action } from '../action';
import { Construct } from "../../../core";
/**
 * (experimental) How should the CodeCommit Action detect changes.
 *
 * This is the type of the {@link CodeCommitSourceAction.trigger} property.
 *
 * @experimental
 */
export declare enum CodeCommitTrigger {
    /**
     * (experimental) The Action will never detect changes - the Pipeline it's part of will only begin a run when explicitly started.
     *
     * @experimental
     */
    NONE = "None",
    /**
     * (experimental) CodePipeline will poll the repository to detect changes.
     *
     * @experimental
     */
    POLL = "Poll",
    /**
     * (experimental) CodePipeline will use CloudWatch Events to be notified of changes.
     *
     * This is the default method of detecting changes.
     *
     * @experimental
     */
    EVENTS = "Events"
}
/**
 * (experimental) The CodePipeline variables emitted by the CodeCommit source Action.
 *
 * @experimental
 */
export interface CodeCommitSourceVariables {
    /**
     * (experimental) The name of the repository this action points to.
     *
     * @experimental
     */
    readonly repositoryName: string;
    /**
     * (experimental) The name of the branch this action tracks.
     *
     * @experimental
     */
    readonly branchName: string;
    /**
     * (experimental) The date the currently last commit on the tracked branch was authored, in ISO-8601 format.
     *
     * @experimental
     */
    readonly authorDate: string;
    /**
     * (experimental) The date the currently last commit on the tracked branch was committed, in ISO-8601 format.
     *
     * @experimental
     */
    readonly committerDate: string;
    /**
     * (experimental) The SHA1 hash of the currently last commit on the tracked branch.
     *
     * @experimental
     */
    readonly commitId: string;
    /**
     * (experimental) The message of the currently last commit on the tracked branch.
     *
     * @experimental
     */
    readonly commitMessage: string;
}
/**
 * (experimental) Construction properties of the {@link CodeCommitSourceAction CodeCommit source CodePipeline Action}.
 *
 * @experimental
 */
export interface CodeCommitSourceActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * @experimental
     */
    readonly output: codepipeline.Artifact;
    /**
     * @default 'master'
     * @experimental
     */
    readonly branch?: string;
    /**
     * (experimental) How should CodePipeline detect source changes for this Action.
     *
     * @default CodeCommitTrigger.EVENTS
     * @experimental
     */
    readonly trigger?: CodeCommitTrigger;
    /**
     * (experimental) The CodeCommit repository.
     *
     * @experimental
     */
    readonly repository: codecommit.IRepository;
    /**
     * (experimental) Role to be used by on commit event rule.
     *
     * Used only when trigger value is CodeCommitTrigger.EVENTS.
     *
     * @default a new role will be created.
     * @experimental
     */
    readonly eventRole?: iam.IRole;
    /**
     * (experimental) Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building.
     *
     * **Note**: if this option is true,
     * then only CodeBuild actions can use the resulting {@link output}.
     *
     * @default false
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeCommit.html
     * @experimental
     */
    readonly codeBuildCloneOutput?: boolean;
}
/**
 * (experimental) CodePipeline Source that is provided by an AWS CodeCommit repository.
 *
 * @experimental
 */
export declare class CodeCommitSourceAction extends Action {
    /**
     * The name of the property that holds the ARN of the CodeCommit Repository
     * inside of the CodePipeline Artifact's metadata.
     *
     * @internal
     */
    static readonly _FULL_CLONE_ARN_PROPERTY = "CodeCommitCloneRepositoryArn";
    private readonly branch;
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: CodeCommitSourceActionProps);
    /**
     * (experimental) The variables emitted by this action.
     *
     * @experimental
     */
    get variables(): CodeCommitSourceVariables;
    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     *
     * @experimental
     */
    protected bound(_scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    private generateEventId;
    private eventIdFromPrefix;
}
