import * as codepipeline from "../../../aws-codepipeline";
import { SecretValue } from "../../../core";
import { Action } from '../action';
import { Construct } from "../../../core";
/**
 * (experimental) Construction properties of the {@link AlexaSkillDeployAction Alexa deploy Action}.
 *
 * @experimental
 */
export interface AlexaSkillDeployActionProps extends codepipeline.CommonActionProps {
    /**
     * (experimental) The client id of the developer console token.
     *
     * @experimental
     */
    readonly clientId: string;
    /**
     * (experimental) The client secret of the developer console token.
     *
     * @experimental
     */
    readonly clientSecret: SecretValue;
    /**
     * (experimental) The refresh token of the developer console token.
     *
     * @experimental
     */
    readonly refreshToken: SecretValue;
    /**
     * (experimental) The Alexa skill id.
     *
     * @experimental
     */
    readonly skillId: string;
    /**
     * (experimental) The source artifact containing the voice model and skill manifest.
     *
     * @experimental
     */
    readonly input: codepipeline.Artifact;
    /**
     * (experimental) An optional artifact containing overrides for the skill manifest.
     *
     * @experimental
     */
    readonly parameterOverridesArtifact?: codepipeline.Artifact;
}
/**
 * (experimental) Deploys the skill to Alexa.
 *
 * @experimental
 */
export declare class AlexaSkillDeployAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: AlexaSkillDeployActionProps);
    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     *
     * @experimental
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, _options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
