"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDeploymentConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("../utils");
/**
 * (experimental) A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @experimental
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class LambdaDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom lambda deployment configurations
    }
    /**
     * (experimental) Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct.
     * @param _id the logical ID of this new Construct.
     * @param props the properties of the referenced custom Deployment Configuration.
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     * @experimental
     */
    static import(_scope, _id, props) {
        return deploymentConfig(props.deploymentConfigName);
    }
}
exports.LambdaDeploymentConfig = LambdaDeploymentConfig;
_a = JSII_RTTI_SYMBOL_1;
LambdaDeploymentConfig[_a] = { fqn: "monocdk.aws_codedeploy.LambdaDeploymentConfig", version: "1.106.1" };
/**
 * @experimental
 */
LambdaDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.LambdaAllAtOnce');
/**
 * @experimental
 */
LambdaDeploymentConfig.CANARY_10PERCENT_30MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent30Minutes');
/**
 * @experimental
 */
LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent5Minutes');
/**
 * @experimental
 */
LambdaDeploymentConfig.CANARY_10PERCENT_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent10Minutes');
/**
 * @experimental
 */
LambdaDeploymentConfig.CANARY_10PERCENT_15MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent15Minutes');
/**
 * @experimental
 */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery10Minutes');
/**
 * @experimental
 */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery1Minute');
/**
 * @experimental
 */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_2MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery2Minutes');
/**
 * @experimental
 */
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery3Minutes');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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