import * as cdk from "../../../core";
import { Construct } from 'constructs';
import { IEcsApplication } from './application';
import { IEcsDeploymentConfig } from './deployment-config';
/**
 * (experimental) Interface for an ECS deployment group.
 *
 * @experimental
 */
export interface IEcsDeploymentGroup extends cdk.IResource {
    /**
     * (experimental) The reference to the CodeDeploy ECS Application that this Deployment Group belongs to.
     *
     * @experimental
     */
    readonly application: IEcsApplication;
    /**
     * (experimental) The physical name of the CodeDeploy Deployment Group.
     *
     * @experimental
     * @attribute true
     */
    readonly deploymentGroupName: string;
    /**
     * (experimental) The ARN of this Deployment Group.
     *
     * @experimental
     * @attribute true
     */
    readonly deploymentGroupArn: string;
    /**
     * (experimental) The Deployment Configuration this Group uses.
     *
     * @experimental
     */
    readonly deploymentConfig: IEcsDeploymentConfig;
}
/**
 * (experimental) Note: This class currently stands as a namespaced container for importing an ECS Deployment Group defined outside the CDK app until CloudFormation supports provisioning ECS Deployment Groups.
 *
 * Until then it is closed (private constructor) and does not
 * extend {@link cdk.Construct}.
 *
 * @experimental
 * @resource AWS::CodeDeploy::DeploymentGroup
 */
export declare class EcsDeploymentGroup {
    /**
     * (experimental) Import an ECS Deployment Group defined outside the CDK app.
     *
     * @param scope the parent Construct for this new Construct.
     * @param id the logical ID of this new Construct.
     * @param attrs the properties of the referenced Deployment Group.
     * @returns a Construct representing a reference to an existing Deployment Group
     * @experimental
     */
    static fromEcsDeploymentGroupAttributes(scope: Construct, id: string, attrs: EcsDeploymentGroupAttributes): IEcsDeploymentGroup;
    private constructor();
}
/**
 * (experimental) Properties of a reference to a CodeDeploy ECS Deployment Group.
 *
 * @see EcsDeploymentGroup#fromEcsDeploymentGroupAttributes
 * @experimental
 */
export interface EcsDeploymentGroupAttributes {
    /**
     * (experimental) The reference to the CodeDeploy ECS Application that this Deployment Group belongs to.
     *
     * @experimental
     */
    readonly application: IEcsApplication;
    /**
     * (experimental) The physical, human-readable name of the CodeDeploy ECS Deployment Group that we are referencing.
     *
     * @experimental
     */
    readonly deploymentGroupName: string;
    /**
     * (experimental) The Deployment Configuration this Deployment Group uses.
     *
     * @default EcsDeploymentConfig.ALL_AT_ONCE
     * @experimental
     */
    readonly deploymentConfig?: IEcsDeploymentConfig;
}
