"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeploymentConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("../utils");
/**
 * (experimental) A custom Deployment Configuration for an ECS Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom ECS Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @experimental
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class EcsDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom ECS deployment configurations
    }
    /**
     * (experimental) Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct.
     * @param _id the logical ID of this new Construct.
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration.
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     * @experimental
     */
    static fromEcsDeploymentConfigName(_scope, _id, ecsDeploymentConfigName) {
        return deploymentConfig(ecsDeploymentConfigName);
    }
}
exports.EcsDeploymentConfig = EcsDeploymentConfig;
_a = JSII_RTTI_SYMBOL_1;
EcsDeploymentConfig[_a] = { fqn: "monocdk.aws_codedeploy.EcsDeploymentConfig", version: "1.106.1" };
/**
 * @experimental
 */
EcsDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.ECSAllAtOnce');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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