"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferenceEvent = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
/**
 * (experimental) Fields of CloudWatch Events that change references.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type
 * @experimental
 */
class ReferenceEvent {
    constructor() {
    }
    /**
     * (experimental) The type of reference event.
     *
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     *
     * @experimental
     */
    static get eventType() {
        return events.EventField.fromPath('$.detail.event');
    }
    /**
     * (experimental) Name of the CodeCommit repository.
     *
     * @experimental
     */
    static get repositoryName() {
        return events.EventField.fromPath('$.detail.repositoryName');
    }
    /**
     * (experimental) Id of the CodeCommit repository.
     *
     * @experimental
     */
    static get repositoryId() {
        return events.EventField.fromPath('$.detail.repositoryId');
    }
    /**
     * (experimental) Type of reference changed.
     *
     * 'branch' or 'tag'
     *
     * @experimental
     */
    static get referenceType() {
        return events.EventField.fromPath('$.detail.referenceType');
    }
    /**
     * (experimental) Name of reference changed (branch or tag name).
     *
     * @experimental
     */
    static get referenceName() {
        return events.EventField.fromPath('$.detail.referenceName');
    }
    /**
     * (experimental) Full reference name.
     *
     * For example, 'refs/tags/myTag'
     *
     * @experimental
     */
    static get referenceFullName() {
        return events.EventField.fromPath('$.detail.referenceFullName');
    }
    /**
     * (experimental) Commit id this reference now points to.
     *
     * @experimental
     */
    static get commitId() {
        return events.EventField.fromPath('$.detail.commitId');
    }
}
exports.ReferenceEvent = ReferenceEvent;
_a = JSII_RTTI_SYMBOL_1;
ReferenceEvent[_a] = { fqn: "monocdk.aws_codecommit.ReferenceEvent", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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