/**
 * (experimental) Fields of CloudWatch Events that change references.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type
 * @experimental
 */
export declare class ReferenceEvent {
    /**
     * (experimental) The type of reference event.
     *
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     *
     * @experimental
     */
    static get eventType(): string;
    /**
     * (experimental) Name of the CodeCommit repository.
     *
     * @experimental
     */
    static get repositoryName(): string;
    /**
     * (experimental) Id of the CodeCommit repository.
     *
     * @experimental
     */
    static get repositoryId(): string;
    /**
     * (experimental) Type of reference changed.
     *
     * 'branch' or 'tag'
     *
     * @experimental
     */
    static get referenceType(): string;
    /**
     * (experimental) Name of reference changed (branch or tag name).
     *
     * @experimental
     */
    static get referenceName(): string;
    /**
     * (experimental) Full reference name.
     *
     * For example, 'refs/tags/myTag'
     *
     * @experimental
     */
    static get referenceFullName(): string;
    /**
     * (experimental) Commit id this reference now points to.
     *
     * @experimental
     */
    static get commitId(): string;
    private constructor();
}
