import * as codecommit from "../../aws-codecommit";
import * as s3 from "../../aws-s3";
import { CfnProject } from './codebuild.generated';
import { IProject } from './project';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) The type returned from {@link ISource#bind}.
 *
 * @experimental
 */
export interface SourceConfig {
    /**
     * @experimental
     */
    readonly sourceProperty: CfnProject.SourceProperty;
    /**
     * @experimental
     */
    readonly buildTriggers?: CfnProject.ProjectTriggersProperty;
    /**
     * (experimental) `AWS::CodeBuild::Project.SourceVersion`.
     *
     * @default the latest version
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-sourceversion
     * @experimental
     */
    readonly sourceVersion?: string;
}
/**
 * (experimental) The abstract interface of a CodeBuild source.
 *
 * Implemented by {@link Source}.
 *
 * @experimental
 */
export interface ISource {
    /**
     * @experimental
     */
    readonly identifier?: string;
    /**
     * @experimental
     */
    readonly type: string;
    /**
     * @experimental
     */
    readonly badgeSupported: boolean;
    /**
     * @experimental
     */
    bind(scope: CoreConstruct, project: IProject): SourceConfig;
}
/**
 * (experimental) Properties common to all Source classes.
 *
 * @experimental
 */
export interface SourceProps {
    /**
     * (experimental) The source identifier.
     *
     * This property is required on secondary sources.
     *
     * @experimental
     */
    readonly identifier?: string;
}
/**
 * (experimental) Source provider definition for a CodeBuild Project.
 *
 * @experimental
 */
export declare abstract class Source implements ISource {
    /**
     * @experimental
     */
    static s3(props: S3SourceProps): ISource;
    /**
     * @experimental
     */
    static codeCommit(props: CodeCommitSourceProps): ISource;
    /**
     * @experimental
     */
    static gitHub(props: GitHubSourceProps): ISource;
    /**
     * @experimental
     */
    static gitHubEnterprise(props: GitHubEnterpriseSourceProps): ISource;
    /**
     * @experimental
     */
    static bitBucket(props: BitBucketSourceProps): ISource;
    /**
     * @experimental
     */
    readonly identifier?: string;
    /**
     * @experimental
     */
    abstract readonly type: string;
    /**
     * @experimental
     */
    readonly badgeSupported: boolean;
    /**
     * @experimental
     */
    protected constructor(props: SourceProps);
    /**
     * (experimental) Called by the project when the source is added so that the source can perform binding operations on the source.
     *
     * For example, it can grant permissions to the
     * code build project to read from the S3 bucket.
     *
     * @experimental
     */
    bind(_scope: CoreConstruct, _project: IProject): SourceConfig;
}
/**
 * The construction properties common to all build sources that are backed by Git.
 */
interface GitSourceProps extends SourceProps {
    /**
     * (experimental) The depth of history to download.
     *
     * Minimum value is 0.
     * If this value is 0, greater than 25, or not provided,
     * then the full history is downloaded with each build of the project.
     *
     * @experimental
     */
    readonly cloneDepth?: number;
    /**
     * (experimental) The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
     *
     * @default the default branch's HEAD commit ID is used
     * @experimental
     * @example
     *
     * 'mybranch'
     */
    readonly branchOrRef?: string;
    /**
     * (experimental) Whether to fetch submodules while cloning git repo.
     *
     * @default false
     * @experimental
     */
    readonly fetchSubmodules?: boolean;
}
/**
 * (experimental) The types of webhook event actions.
 *
 * @experimental
 */
export declare enum EventAction {
    /**
     * (experimental) A push (of a branch, or a tag) to the repository.
     *
     * @experimental
     */
    PUSH = "PUSH",
    /**
     * (experimental) Creating a Pull Request.
     *
     * @experimental
     */
    PULL_REQUEST_CREATED = "PULL_REQUEST_CREATED",
    /**
     * (experimental) Updating a Pull Request.
     *
     * @experimental
     */
    PULL_REQUEST_UPDATED = "PULL_REQUEST_UPDATED",
    /**
     * (experimental) Merging a Pull Request.
     *
     * @experimental
     */
    PULL_REQUEST_MERGED = "PULL_REQUEST_MERGED",
    /**
     * (experimental) Re-opening a previously closed Pull Request.
     *
     * Note that this event is only supported for GitHub and GitHubEnterprise sources.
     *
     * @experimental
     */
    PULL_REQUEST_REOPENED = "PULL_REQUEST_REOPENED"
}
/**
 * (experimental) An object that represents a group of filter conditions for a webhook.
 *
 * Every condition in a given FilterGroup must be true in order for the whole group to be true.
 * You construct instances of it by calling the {@link #inEventOf} static factory method,
 * and then calling various `andXyz` instance methods to create modified instances of it
 * (this class is immutable).
 *
 * You pass instances of this class to the `webhookFilters` property when constructing a source.
 *
 * @experimental
 */
export declare class FilterGroup {
    /**
     * (experimental) Creates a new event FilterGroup that triggers on any of the provided actions.
     *
     * @param actions the actions to trigger the webhook on.
     * @experimental
     */
    static inEventOf(...actions: EventAction[]): FilterGroup;
    private readonly actions;
    private readonly filters;
    private constructor();
    /**
     * (experimental) Create a new FilterGroup with an added condition: the event must affect the given branch.
     *
     * @param branchName the name of the branch (can be a regular expression).
     * @experimental
     */
    andBranchIs(branchName: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the event must not affect the given branch.
     *
     * @param branchName the name of the branch (can be a regular expression).
     * @experimental
     */
    andBranchIsNot(branchName: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the event must affect a head commit with the given message.
     *
     * @param commitMessage the commit message (can be a regular expression).
     * @experimental
     */
    andCommitMessageIs(commitMessage: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the event must not affect a head commit with the given message.
     *
     * @param commitMessage the commit message (can be a regular expression).
     * @experimental
     */
    andCommitMessageIsNot(commitMessage: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the event must affect the given tag.
     *
     * @param tagName the name of the tag (can be a regular expression).
     * @experimental
     */
    andTagIs(tagName: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the event must not affect the given tag.
     *
     * @param tagName the name of the tag (can be a regular expression).
     * @experimental
     */
    andTagIsNot(tagName: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the event must affect a Git reference (ie., a branch or a tag) that matches the given pattern.
     *
     * @param pattern a regular expression.
     * @experimental
     */
    andHeadRefIs(pattern: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the event must not affect a Git reference (ie., a branch or a tag) that matches the given pattern.
     *
     * @param pattern a regular expression.
     * @experimental
     */
    andHeadRefIsNot(pattern: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the account ID of the actor initiating the event must match the given pattern.
     *
     * @param pattern a regular expression.
     * @experimental
     */
    andActorAccountIs(pattern: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the account ID of the actor initiating the event must not match the given pattern.
     *
     * @param pattern a regular expression.
     * @experimental
     */
    andActorAccountIsNot(pattern: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the Pull Request that is the source of the event must target the given base branch.
     *
     * Note that you cannot use this method if this Group contains the `PUSH` event action.
     *
     * @param branchName the name of the branch (can be a regular expression).
     * @experimental
     */
    andBaseBranchIs(branchName: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the Pull Request that is the source of the event must not target the given base branch.
     *
     * Note that you cannot use this method if this Group contains the `PUSH` event action.
     *
     * @param branchName the name of the branch (can be a regular expression).
     * @experimental
     */
    andBaseBranchIsNot(branchName: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the Pull Request that is the source of the event must target the given Git reference.
     *
     * Note that you cannot use this method if this Group contains the `PUSH` event action.
     *
     * @param pattern a regular expression.
     * @experimental
     */
    andBaseRefIs(pattern: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the Pull Request that is the source of the event must not target the given Git reference.
     *
     * Note that you cannot use this method if this Group contains the `PUSH` event action.
     *
     * @param pattern a regular expression.
     * @experimental
     */
    andBaseRefIsNot(pattern: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the push that is the source of the event must affect a file that matches the given pattern.
     *
     * Note that you can only use this method if this Group contains only the `PUSH` event action,
     * and only for GitHub, Bitbucket and GitHubEnterprise sources.
     *
     * @param pattern a regular expression.
     * @experimental
     */
    andFilePathIs(pattern: string): FilterGroup;
    /**
     * (experimental) Create a new FilterGroup with an added condition: the push that is the source of the event must not affect a file that matches the given pattern.
     *
     * Note that you can only use this method if this Group contains only the `PUSH` event action,
     * and only for GitHub, Bitbucket and GitHubEnterprise sources.
     *
     * @param pattern a regular expression.
     * @experimental
     */
    andFilePathIsNot(pattern: string): FilterGroup;
    /** @internal */
    get _actions(): EventAction[];
    /** @internal */
    get _filters(): CfnProject.WebhookFilterProperty[];
    /** @internal */
    _toJson(): CfnProject.WebhookFilterProperty[];
    private addCommitMessageFilter;
    private addHeadBranchFilter;
    private addHeadTagFilter;
    private addHeadRefFilter;
    private addActorAccountId;
    private addBaseBranchFilter;
    private addBaseRefFilter;
    private addFilePathFilter;
    private addFilter;
}
/**
 * The construction properties common to all third-party build sources that are backed by Git.
 */
interface ThirdPartyGitSourceProps extends GitSourceProps {
    /**
     * (experimental) Whether to send notifications on your build's start and end.
     *
     * @default true
     * @experimental
     */
    readonly reportBuildStatus?: boolean;
    /**
     * (experimental) Whether to create a webhook that will trigger a build every time an event happens in the repository.
     *
     * @default true if any `webhookFilters` were provided, false otherwise
     * @experimental
     */
    readonly webhook?: boolean;
    /**
     * (experimental) Trigger a batch build from a webhook instead of a standard one.
     *
     * Enabling this will enable batch builds on the CodeBuild project.
     *
     * @default false
     * @experimental
     */
    readonly webhookTriggersBatchBuild?: boolean;
    /**
     * (experimental) A list of webhook filters that can constraint what events in the repository will trigger a build.
     *
     * A build is triggered if any of the provided filter groups match.
     * Only valid if `webhook` was not provided as false.
     *
     * @default every push and every Pull Request (create or update) triggers a build
     * @experimental
     */
    readonly webhookFilters?: FilterGroup[];
}
/**
 * (experimental) Construction properties for {@link CodeCommitSource}.
 *
 * @experimental
 */
export interface CodeCommitSourceProps extends GitSourceProps {
    /**
     * @experimental
     */
    readonly repository: codecommit.IRepository;
}
/**
 * (experimental) Construction properties for {@link S3Source}.
 *
 * @experimental
 */
export interface S3SourceProps extends SourceProps {
    /**
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * @experimental
     */
    readonly path: string;
    /**
     * (experimental) The version ID of the object that represents the build input ZIP file to use.
     *
     * @default latest
     * @experimental
     */
    readonly version?: string;
}
/**
 * (experimental) Construction properties for {@link GitHubSource} and {@link GitHubEnterpriseSource}.
 *
 * @experimental
 */
export interface GitHubSourceProps extends ThirdPartyGitSourceProps {
    /**
     * (experimental) The GitHub account/user that owns the repo.
     *
     * @experimental
     * @example
     *
     * 'awslabs'
     */
    readonly owner: string;
    /**
     * (experimental) The name of the repo (without the username).
     *
     * @experimental
     * @example
     *
     * 'aws-cdk'
     */
    readonly repo: string;
}
/**
 * (experimental) Construction properties for {@link GitHubEnterpriseSource}.
 *
 * @experimental
 */
export interface GitHubEnterpriseSourceProps extends ThirdPartyGitSourceProps {
    /**
     * (experimental) The HTTPS URL of the repository in your GitHub Enterprise installation.
     *
     * @experimental
     */
    readonly httpsCloneUrl: string;
    /**
     * (experimental) Whether to ignore SSL errors when connecting to the repository.
     *
     * @default false
     * @experimental
     */
    readonly ignoreSslErrors?: boolean;
}
/**
 * (experimental) Construction properties for {@link BitBucketSource}.
 *
 * @experimental
 */
export interface BitBucketSourceProps extends ThirdPartyGitSourceProps {
    /**
     * (experimental) The BitBucket account/user that owns the repo.
     *
     * @experimental
     * @example
     *
     * 'awslabs'
     */
    readonly owner: string;
    /**
     * (experimental) The name of the repo (without the username).
     *
     * @experimental
     * @example
     *
     * 'aws-cdk'
     */
    readonly repo: string;
}
export {};
