import { Resource, SecretValue } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Creation properties for {@link GitHubSourceCredentials}.
 *
 * @experimental
 */
export interface GitHubSourceCredentialsProps {
    /**
     * (experimental) The personal access token to use when contacting the GitHub API.
     *
     * @experimental
     */
    readonly accessToken: SecretValue;
}
/**
 * (experimental) The source credentials used when contacting the GitHub API.
 *
 * **Note**: CodeBuild only allows a single credential for GitHub
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @experimental
 * @resource AWS::CodeBuild::SourceCredential
 */
export declare class GitHubSourceCredentials extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: GitHubSourceCredentialsProps);
}
/**
 * (experimental) Creation properties for {@link GitHubEnterpriseSourceCredentials}.
 *
 * @experimental
 */
export interface GitHubEnterpriseSourceCredentialsProps {
    /**
     * (experimental) The personal access token to use when contacting the instance of the GitHub Enterprise API.
     *
     * @experimental
     */
    readonly accessToken: SecretValue;
}
/**
 * (experimental) The source credentials used when contacting the GitHub Enterprise API.
 *
 * **Note**: CodeBuild only allows a single credential for GitHub Enterprise
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @experimental
 * @resource AWS::CodeBuild::SourceCredential
 */
export declare class GitHubEnterpriseSourceCredentials extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: GitHubEnterpriseSourceCredentialsProps);
}
/**
 * (experimental) Construction properties of {@link BitBucketSourceCredentials}.
 *
 * @experimental
 */
export interface BitBucketSourceCredentialsProps {
    /**
     * (experimental) Your BitBucket username.
     *
     * @experimental
     */
    readonly username: SecretValue;
    /**
     * (experimental) Your BitBucket application password.
     *
     * @experimental
     */
    readonly password: SecretValue;
}
/**
 * (experimental) The source credentials used when contacting the BitBucket API.
 *
 * **Note**: CodeBuild only allows a single credential for BitBucket
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @experimental
 * @resource AWS::CodeBuild::SourceCredential
 */
export declare class BitBucketSourceCredentials extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BitBucketSourceCredentialsProps);
}
