import * as iam from "../../aws-iam";
import * as s3 from "../../aws-s3";
import * as cdk from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) The interface representing the ReportGroup resource - either an existing one, imported using the {@link ReportGroup.fromReportGroupName} method, or a new one, created with the {@link ReportGroup} class.
 *
 * @experimental
 */
export interface IReportGroup extends cdk.IResource {
    /**
     * (experimental) The ARN of the ReportGroup.
     *
     * @experimental
     * @attribute true
     */
    readonly reportGroupArn: string;
    /**
     * (experimental) The name of the ReportGroup.
     *
     * @experimental
     * @attribute true
     */
    readonly reportGroupName: string;
    /**
     * (experimental) Grants the given entity permissions to write (that is, upload reports to) this report group.
     *
     * @experimental
     */
    grantWrite(identity: iam.IGrantable): iam.Grant;
}
declare abstract class ReportGroupBase extends cdk.Resource implements IReportGroup {
    abstract readonly reportGroupArn: string;
    abstract readonly reportGroupName: string;
    protected abstract readonly exportBucket?: s3.IBucket;
    /**
     * (experimental) Grants the given entity permissions to write (that is, upload reports to) this report group.
     *
     * @experimental
     */
    grantWrite(identity: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Construction properties for {@link ReportGroup}.
 *
 * @experimental
 */
export interface ReportGroupProps {
    /**
     * (experimental) The physical name of the report group.
     *
     * @default - CloudFormation-generated name
     * @experimental
     */
    readonly reportGroupName?: string;
    /**
     * (experimental) An optional S3 bucket to export the reports to.
     *
     * @default - the reports will not be exported
     * @experimental
     */
    readonly exportBucket?: s3.IBucket;
    /**
     * (experimental) Whether to output the report files into the export bucket as-is, or create a ZIP from them before doing the export.
     *
     * Ignored if {@link exportBucket} has not been provided.
     *
     * @default - false (the files will not be ZIPped)
     * @experimental
     */
    readonly zipExport?: boolean;
    /**
     * (experimental) What to do when this resource is deleted from a stack.
     *
     * As CodeBuild does not allow deleting a ResourceGroup that has reports inside of it,
     * this is set to retain the resource by default.
     *
     * @default RemovalPolicy.RETAIN
     * @experimental
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
}
/**
 * (experimental) The ReportGroup resource class.
 *
 * @experimental
 */
export declare class ReportGroup extends ReportGroupBase {
    /**
     * (experimental) Reference an existing ReportGroup, defined outside of the CDK code, by name.
     *
     * @experimental
     */
    static fromReportGroupName(scope: Construct, id: string, reportGroupName: string): IReportGroup;
    /**
     * (experimental) The ARN of the ReportGroup.
     *
     * @experimental
     */
    readonly reportGroupArn: string;
    /**
     * (experimental) The name of the ReportGroup.
     *
     * @experimental
     */
    readonly reportGroupName: string;
    /**
     * @experimental
     */
    protected readonly exportBucket?: s3.IBucket;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ReportGroupProps);
}
export {};
