import * as logs from "../../aws-logs";
import * as s3 from "../../aws-s3";
/**
 * (experimental) Information about logs built to an S3 bucket for a build project.
 *
 * @experimental
 */
export interface S3LoggingOptions {
    /**
     * (experimental) Encrypt the S3 build log output.
     *
     * @default true
     * @experimental
     */
    readonly encrypted?: boolean;
    /**
     * (experimental) The S3 Bucket to send logs to.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * (experimental) The path prefix for S3 logs.
     *
     * @default - no prefix
     * @experimental
     */
    readonly prefix?: string;
    /**
     * (experimental) The current status of the logs in Amazon CloudWatch Logs for a build project.
     *
     * @default true
     * @experimental
     */
    readonly enabled?: boolean;
}
/**
 * (experimental) Information about logs built to a CloudWatch Log Group for a build project.
 *
 * @experimental
 */
export interface CloudWatchLoggingOptions {
    /**
     * (experimental) The Log Group to send logs to.
     *
     * @default - no log group specified
     * @experimental
     */
    readonly logGroup?: logs.ILogGroup;
    /**
     * (experimental) The prefix of the stream name of the Amazon CloudWatch Logs.
     *
     * @default - no prefix
     * @experimental
     */
    readonly prefix?: string;
    /**
     * (experimental) The current status of the logs in Amazon CloudWatch Logs for a build project.
     *
     * @default true
     * @experimental
     */
    readonly enabled?: boolean;
}
/**
 * (experimental) Information about logs for the build project.
 *
 * A project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
 *
 * @experimental
 */
export interface LoggingOptions {
    /**
     * (experimental) Information about logs built to an S3 bucket for a build project.
     *
     * @default - disabled
     * @experimental
     */
    readonly s3?: S3LoggingOptions;
    /**
     * (experimental) Information about Amazon CloudWatch Logs for a build project.
     *
     * @default - enabled
     * @experimental
     */
    readonly cloudWatch?: CloudWatchLoggingOptions;
}
