"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serialize = void 0;
const yaml = require("yaml");
const yaml_types = require("yaml/types");
/**
 * Serializes the given data structure into valid YAML.
 *
 * @param obj the data structure to serialize
 * @returns a string containing the YAML representation of {@param obj}
 */
function serialize(obj) {
    const oldFold = yaml_types.strOptions.fold.lineWidth;
    try {
        yaml_types.strOptions.fold.lineWidth = 0;
        return yaml.stringify(obj, { schema: 'yaml-1.1' });
    }
    finally {
        yaml_types.strOptions.fold.lineWidth = oldFold;
    }
}
exports.serialize = serialize;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoieWFtbC1jZm4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ5YW1sLWNmbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2QkFBNkI7QUFDN0IseUNBQXlDO0FBQ3pDOzs7OztHQUtHO0FBQ0gsU0FBZ0IsU0FBUyxDQUFDLEdBQVE7SUFDOUIsTUFBTSxPQUFPLEdBQUcsVUFBVSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3JELElBQUk7UUFDQSxVQUFVLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxTQUFTLEdBQUcsQ0FBQyxDQUFDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxNQUFNLEVBQUUsVUFBVSxFQUFFLENBQUMsQ0FBQztLQUN0RDtZQUNPO1FBQ0osVUFBVSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsU0FBUyxHQUFHLE9BQU8sQ0FBQztLQUNsRDtBQUNMLENBQUM7QUFURCw4QkFTQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHlhbWwgZnJvbSAneWFtbCc7XG5pbXBvcnQgKiBhcyB5YW1sX3R5cGVzIGZyb20gJ3lhbWwvdHlwZXMnO1xuLyoqXG4gKiBTZXJpYWxpemVzIHRoZSBnaXZlbiBkYXRhIHN0cnVjdHVyZSBpbnRvIHZhbGlkIFlBTUwuXG4gKlxuICogQHBhcmFtIG9iaiB0aGUgZGF0YSBzdHJ1Y3R1cmUgdG8gc2VyaWFsaXplXG4gKiBAcmV0dXJucyBhIHN0cmluZyBjb250YWluaW5nIHRoZSBZQU1MIHJlcHJlc2VudGF0aW9uIG9mIHtAcGFyYW0gb2JqfVxuICovXG5leHBvcnQgZnVuY3Rpb24gc2VyaWFsaXplKG9iajogYW55KTogc3RyaW5nIHtcbiAgICBjb25zdCBvbGRGb2xkID0geWFtbF90eXBlcy5zdHJPcHRpb25zLmZvbGQubGluZVdpZHRoO1xuICAgIHRyeSB7XG4gICAgICAgIHlhbWxfdHlwZXMuc3RyT3B0aW9ucy5mb2xkLmxpbmVXaWR0aCA9IDA7XG4gICAgICAgIHJldHVybiB5YW1sLnN0cmluZ2lmeShvYmosIHsgc2NoZW1hOiAneWFtbC0xLjEnIH0pO1xuICAgIH1cbiAgICBmaW5hbGx5IHtcbiAgICAgICAgeWFtbF90eXBlcy5zdHJPcHRpb25zLmZvbGQubGluZVdpZHRoID0gb2xkRm9sZDtcbiAgICB9XG59XG4iXX0=