"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = exports.LocalCacheMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Local cache modes to enable for the CodeBuild Project.
 *
 * @experimental
 */
var LocalCacheMode;
(function (LocalCacheMode) {
    LocalCacheMode["SOURCE"] = "LOCAL_SOURCE_CACHE";
    LocalCacheMode["DOCKER_LAYER"] = "LOCAL_DOCKER_LAYER_CACHE";
    LocalCacheMode["CUSTOM"] = "LOCAL_CUSTOM_CACHE";
})(LocalCacheMode = exports.LocalCacheMode || (exports.LocalCacheMode = {}));
/**
 * (experimental) Cache options for CodeBuild Project.
 *
 * A cache can store reusable pieces of your build environment and use them across multiple builds.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-caching.html
 * @experimental
 */
class Cache {
    /**
     * @experimental
     */
    static none() {
        return { _toCloudFormation: () => undefined, _bind: () => { return; } };
    }
    /**
     * (experimental) Create a local caching strategy.
     *
     * @param modes the mode(s) to enable for local caching.
     * @experimental
     */
    static local(...modes) {
        return {
            _toCloudFormation: () => ({
                type: 'LOCAL',
                modes,
            }),
            _bind: () => { return; },
        };
    }
    /**
     * (experimental) Create an S3 caching strategy.
     *
     * @param bucket the S3 bucket to use for caching.
     * @param options additional options to pass to the S3 caching.
     * @experimental
     */
    static bucket(bucket, options) {
        return {
            _toCloudFormation: () => ({
                type: 'S3',
                location: core_1.Fn.join('/', [bucket.bucketName, options && options.prefix || core_1.Aws.NO_VALUE]),
            }),
            _bind: (project) => {
                bucket.grantReadWrite(project);
            },
        };
    }
}
exports.Cache = Cache;
_a = JSII_RTTI_SYMBOL_1;
Cache[_a] = { fqn: "monocdk.aws_codebuild.Cache", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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