import { IBucket } from "../../aws-s3";
import { CfnProject } from './codebuild.generated';
import { IProject } from './project';
/**
 * @experimental
 */
export interface BucketCacheOptions {
    /**
     * (experimental) The prefix to use to store the cache in the bucket.
     *
     * @experimental
     */
    readonly prefix?: string;
}
/**
 * (experimental) Local cache modes to enable for the CodeBuild Project.
 *
 * @experimental
 */
export declare enum LocalCacheMode {
    /**
     * (experimental) Caches Git metadata for primary and secondary sources.
     *
     * @experimental
     */
    SOURCE = "LOCAL_SOURCE_CACHE",
    /**
     * (experimental) Caches existing Docker layers.
     *
     * @experimental
     */
    DOCKER_LAYER = "LOCAL_DOCKER_LAYER_CACHE",
    /**
     * (experimental) Caches directories you specify in the buildspec file.
     *
     * @experimental
     */
    CUSTOM = "LOCAL_CUSTOM_CACHE"
}
/**
 * (experimental) Cache options for CodeBuild Project.
 *
 * A cache can store reusable pieces of your build environment and use them across multiple builds.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-caching.html
 * @experimental
 */
export declare abstract class Cache {
    /**
     * @experimental
     */
    static none(): Cache;
    /**
     * (experimental) Create a local caching strategy.
     *
     * @param modes the mode(s) to enable for local caching.
     * @experimental
     */
    static local(...modes: LocalCacheMode[]): Cache;
    /**
     * (experimental) Create an S3 caching strategy.
     *
     * @param bucket the S3 bucket to use for caching.
     * @param options additional options to pass to the S3 caching.
     * @experimental
     */
    static bucket(bucket: IBucket, options?: BucketCacheOptions): Cache;
    /**
     * @internal
     */
    abstract _toCloudFormation(): CfnProject.ProjectCacheProperty | undefined;
    /**
     * @internal
     */
    abstract _bind(project: IProject): void;
}
