"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeBuildSpecs = exports.BuildSpec = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const yaml_cfn = require("./private/yaml-cfn");
/**
 * (experimental) BuildSpec for CodeBuild projects.
 *
 * @experimental
 */
class BuildSpec {
    /**
     * @experimental
     */
    constructor() {
    }
    /**
     * @experimental
     */
    static fromObject(value) {
        return new ObjectBuildSpec(value);
    }
    /**
     * (experimental) Create a buildspec from an object that will be rendered as YAML in the resulting CloudFormation template.
     *
     * @param value the object containing the buildspec that will be rendered as YAML.
     * @experimental
     */
    static fromObjectToYaml(value) {
        return new YamlBuildSpec(value);
    }
    /**
     * (experimental) Use a file from the source as buildspec.
     *
     * Use this if you want to use a file different from 'buildspec.yml'`
     *
     * @experimental
     */
    static fromSourceFilename(filename) {
        return new FilenameBuildSpec(filename);
    }
}
exports.BuildSpec = BuildSpec;
_a = JSII_RTTI_SYMBOL_1;
BuildSpec[_a] = { fqn: "monocdk.aws_codebuild.BuildSpec", version: "1.106.1" };
/**
 * BuildSpec that just returns the input unchanged
 */
class FilenameBuildSpec extends BuildSpec {
    constructor(filename) {
        super();
        this.filename = filename;
        this.isImmediate = false;
    }
    toBuildSpec() {
        return this.filename;
    }
    toString() {
        return `<buildspec file: ${this.filename}>`;
    }
}
/**
 * BuildSpec that understands about structure
 */
class ObjectBuildSpec extends BuildSpec {
    constructor(spec) {
        super();
        this.spec = spec;
        this.isImmediate = true;
    }
    toBuildSpec() {
        // We have to pretty-print the buildspec, otherwise
        // CodeBuild will not recognize it as an inline buildspec.
        return core_1.Lazy.uncachedString({
            produce: (ctx) => core_1.Stack.of(ctx.scope).toJsonString(this.spec, 2),
        });
    }
}
/**
 * BuildSpec that exports into YAML format
 */
class YamlBuildSpec extends BuildSpec {
    constructor(spec) {
        super();
        this.spec = spec;
        this.isImmediate = true;
    }
    toBuildSpec() {
        return yaml_cfn.serialize(this.spec);
    }
}
/**
 * Merge two buildspecs into a new BuildSpec
 *
 * NOTE: will currently only merge commands, not artifact
 * declarations, environment variables, secrets, or any
 * other configuration elements.
 *
 * Internal for now because it's not complete/good enough
 * to expose on the objects directly, but we need to it to
 * keep feature-parity for Project.
 *
 * @internal
 */
function mergeBuildSpecs(lhs, rhs) {
    if (!(lhs instanceof ObjectBuildSpec) || !(rhs instanceof ObjectBuildSpec)) {
        throw new Error('Can only merge buildspecs created using BuildSpec.fromObject()');
    }
    return new ObjectBuildSpec(copyCommands(lhs.spec, rhs.spec));
}
exports.mergeBuildSpecs = mergeBuildSpecs;
/**
 * Extend buildSpec phases with the contents of another one
 */
function copyCommands(buildSpec, extend) {
    if (buildSpec.version === '0.1') {
        throw new Error('Cannot extend buildspec at version "0.1". Set the version to "0.2" or higher instead.');
    }
    const ret = Object.assign({}, buildSpec); // Return a copy
    ret.phases = Object.assign({}, ret.phases);
    for (const phaseName of Object.keys(extend.phases)) {
        const phase = ret.phases[phaseName] = Object.assign({}, ret.phases[phaseName]);
        phase.commands = [...phase.commands || [], ...extend.phases[phaseName].commands];
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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