/**
 * (experimental) BuildSpec for CodeBuild projects.
 *
 * @experimental
 */
export declare abstract class BuildSpec {
    /**
     * @experimental
     */
    static fromObject(value: {
        [key: string]: any;
    }): BuildSpec;
    /**
     * (experimental) Create a buildspec from an object that will be rendered as YAML in the resulting CloudFormation template.
     *
     * @param value the object containing the buildspec that will be rendered as YAML.
     * @experimental
     */
    static fromObjectToYaml(value: {
        [key: string]: any;
    }): BuildSpec;
    /**
     * (experimental) Use a file from the source as buildspec.
     *
     * Use this if you want to use a file different from 'buildspec.yml'`
     *
     * @experimental
     */
    static fromSourceFilename(filename: string): BuildSpec;
    /**
     * (experimental) Whether the buildspec is directly available or deferred until build-time.
     *
     * @experimental
     */
    abstract readonly isImmediate: boolean;
    /**
     * @experimental
     */
    protected constructor();
    /**
     * (experimental) Render the represented BuildSpec.
     *
     * @experimental
     */
    abstract toBuildSpec(): string;
}
/**
 * Merge two buildspecs into a new BuildSpec
 *
 * NOTE: will currently only merge commands, not artifact
 * declarations, environment variables, secrets, or any
 * other configuration elements.
 *
 * Internal for now because it's not complete/good enough
 * to expose on the objects directly, but we need to it to
 * keep feature-parity for Project.
 *
 * @internal
 */
export declare function mergeBuildSpecs(lhs: BuildSpec, rhs: BuildSpec): BuildSpec;
