import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::CodeArtifact::Domain`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-domain.html
 */
export interface CfnDomainProps {
    /**
     * `AWS::CodeArtifact::Domain.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-domain.html#cfn-codeartifact-domain-domainname
     */
    readonly domainName: string;
    /**
     * `AWS::CodeArtifact::Domain.EncryptionKey`.
     *
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-domain.html#cfn-codeartifact-domain-encryptionkey
     */
    readonly encryptionKey?: string;
    /**
     * `AWS::CodeArtifact::Domain.PermissionsPolicyDocument`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-domain.html#cfn-codeartifact-domain-permissionspolicydocument
     */
    readonly permissionsPolicyDocument?: any | cdk.IResolvable;
    /**
     * `AWS::CodeArtifact::Domain.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-domain.html#cfn-codeartifact-domain-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CodeArtifact::Domain`.
 *
 * @external
 * @cloudformationResource AWS::CodeArtifact::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-domain.html
 */
export declare class CfnDomain extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeArtifact::Domain";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDomain;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute EncryptionKey
     */
    readonly attrEncryptionKey: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * @external
     * @cloudformationAttribute Owner
     */
    readonly attrOwner: string;
    /**
     * `AWS::CodeArtifact::Domain.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-domain.html#cfn-codeartifact-domain-domainname
     */
    domainName: string;
    /**
     * `AWS::CodeArtifact::Domain.EncryptionKey`.
     *
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-domain.html#cfn-codeartifact-domain-encryptionkey
     */
    encryptionKey: string | undefined;
    /**
     * `AWS::CodeArtifact::Domain.PermissionsPolicyDocument`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-domain.html#cfn-codeartifact-domain-permissionspolicydocument
     */
    permissionsPolicyDocument: any | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeArtifact::Domain.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-domain.html#cfn-codeartifact-domain-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CodeArtifact::Domain`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDomainProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CodeArtifact::Repository`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html
 */
export interface CfnRepositoryProps {
    /**
     * `AWS::CodeArtifact::Repository.DomainName`.
     *
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-domainname
     */
    readonly domainName: string;
    /**
     * `AWS::CodeArtifact::Repository.RepositoryName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-repositoryname
     */
    readonly repositoryName: string;
    /**
     * `AWS::CodeArtifact::Repository.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-description
     */
    readonly description?: string;
    /**
     * `AWS::CodeArtifact::Repository.DomainOwner`.
     *
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-domainowner
     */
    readonly domainOwner?: string;
    /**
     * `AWS::CodeArtifact::Repository.ExternalConnections`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-externalconnections
     */
    readonly externalConnections?: string[];
    /**
     * `AWS::CodeArtifact::Repository.PermissionsPolicyDocument`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-permissionspolicydocument
     */
    readonly permissionsPolicyDocument?: any | cdk.IResolvable;
    /**
     * `AWS::CodeArtifact::Repository.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CodeArtifact::Repository.Upstreams`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-upstreams
     */
    readonly upstreams?: string[];
}
/**
 * A CloudFormation `AWS::CodeArtifact::Repository`.
 *
 * @external
 * @cloudformationResource AWS::CodeArtifact::Repository
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html
 */
export declare class CfnRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeArtifact::Repository";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRepository;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute DomainName
     */
    readonly attrDomainName: string;
    /**
     * @external
     * @cloudformationAttribute DomainOwner
     */
    readonly attrDomainOwner: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::CodeArtifact::Repository.DomainName`.
     *
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-domainname
     */
    domainName: string;
    /**
     * `AWS::CodeArtifact::Repository.RepositoryName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-repositoryname
     */
    repositoryName: string;
    /**
     * `AWS::CodeArtifact::Repository.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-description
     */
    description: string | undefined;
    /**
     * `AWS::CodeArtifact::Repository.DomainOwner`.
     *
     * @external
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-domainowner
     */
    domainOwner: string | undefined;
    /**
     * `AWS::CodeArtifact::Repository.ExternalConnections`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-externalconnections
     */
    externalConnections: string[] | undefined;
    /**
     * `AWS::CodeArtifact::Repository.PermissionsPolicyDocument`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-permissionspolicydocument
     */
    permissionsPolicyDocument: any | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeArtifact::Repository.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CodeArtifact::Repository.Upstreams`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-repository.html#cfn-codeartifact-repository-upstreams
     */
    upstreams: string[] | undefined;
    /**
     * Create a new `AWS::CodeArtifact::Repository`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRepositoryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
