import * as iam from "../../aws-iam";
import * as cdk from "../../core";
import * as constructs from 'constructs';
import { Alarm, ComparisonOperator, TreatMissingData } from './alarm';
import { IMetric, MetricAlarmConfig, MetricConfig, MetricGraphConfig, Unit } from './metric-types';
import { Construct } from "../../core";
export declare type DimensionHash = {
    [dim: string]: any;
};
/**
 * (experimental) Options shared by most methods accepting metric options.
 *
 * @experimental
 */
export interface CommonMetricOptions {
    /**
     * (experimental) The period over which the specified statistic is applied.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly period?: cdk.Duration;
    /**
     * (experimental) What function to use for aggregating.
     *
     * Can be one of the following:
     *
     * - "Minimum" | "min"
     * - "Maximum" | "max"
     * - "Average" | "avg"
     * - "Sum" | "sum"
     * - "SampleCount | "n"
     * - "pNN.NN"
     *
     * @default Average
     * @experimental
     */
    readonly statistic?: string;
    /**
     * (experimental) Dimensions of the metric.
     *
     * @default - No dimensions.
     * @experimental
     */
    readonly dimensions?: DimensionHash;
    /**
     * (experimental) Unit used to filter the metric stream.
     *
     * Only refer to datums emitted to the metric stream with the given unit and
     * ignore all others. Only useful when datums are being emitted to the same
     * metric stream under different units.
     *
     * The default is to use all matric datums in the stream, regardless of unit,
     * which is recommended in nearly all cases.
     *
     * CloudWatch does not honor this property for graphs.
     *
     * @default - All metric datums in the given metric stream
     * @experimental
     */
    readonly unit?: Unit;
    /**
     * (experimental) Label for this metric when added to a Graph in a Dashboard.
     *
     * @default - No label
     * @experimental
     */
    readonly label?: string;
    /**
     * (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The `Color` class has a set of standard colors that can be used here.
     *
     * @default - Automatic color
     * @experimental
     */
    readonly color?: string;
    /**
     * (experimental) Account which this metric comes from.
     *
     * @default - Deployment account.
     * @experimental
     */
    readonly account?: string;
    /**
     * (experimental) Region which this metric comes from.
     *
     * @default - Deployment region.
     * @experimental
     */
    readonly region?: string;
}
/**
 * (experimental) Properties for a metric.
 *
 * @experimental
 */
export interface MetricProps extends CommonMetricOptions {
    /**
     * (experimental) Namespace of the metric.
     *
     * @experimental
     */
    readonly namespace: string;
    /**
     * (experimental) Name of the metric.
     *
     * @experimental
     */
    readonly metricName: string;
}
/**
 * (experimental) Properties of a metric that can be changed.
 *
 * @experimental
 */
export interface MetricOptions extends CommonMetricOptions {
}
/**
 * (experimental) Configurable options for MathExpressions.
 *
 * @experimental
 */
export interface MathExpressionOptions {
    /**
     * (experimental) Label for this metric when added to a Graph in a Dashboard.
     *
     * @default - Expression value is used as label
     * @experimental
     */
    readonly label?: string;
    /**
     * (experimental) Color for this metric when added to a Graph in a Dashboard.
     *
     * @default - Automatic color
     * @experimental
     */
    readonly color?: string;
    /**
     * (experimental) The period over which the expression's statistics are applied.
     *
     * This period overrides all periods in the metrics used in this
     * math expression.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly period?: cdk.Duration;
}
/**
 * (experimental) Properties for a MathExpression.
 *
 * @experimental
 */
export interface MathExpressionProps extends MathExpressionOptions {
    /**
     * (experimental) The expression defining the metric.
     *
     * @experimental
     */
    readonly expression: string;
    /**
     * (experimental) The metrics used in the expression, in a map.
     *
     * The key is the identifier that represents the given metric in the
     * expression, and the value is the actual Metric object.
     *
     * @experimental
     */
    readonly usingMetrics: Record<string, IMetric>;
}
/**
 * (experimental) A metric emitted by a service.
 *
 * The metric is a combination of a metric identifier (namespace, name and dimensions)
 * and an aggregation function (statistic, period and unit).
 *
 * It also contains metadata which is used only in graphs, such as color and label.
 * It makes sense to embed this in here, so that compound constructs can attach
 * that metadata to metrics they expose.
 *
 * This class does not represent a resource, so hence is not a construct. Instead,
 * Metric is an abstraction that makes it easy to specify metrics for use in both
 * alarms and graphs.
 *
 * @experimental
 */
export declare class Metric implements IMetric {
    /**
     * (experimental) Grant permissions to the given identity to write metrics.
     *
     * @param grantee The IAM identity to give permissions to.
     * @experimental
     */
    static grantPutMetricData(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Dimensions of this metric.
     *
     * @experimental
     */
    readonly dimensions?: DimensionHash;
    /**
     * (experimental) Namespace of this metric.
     *
     * @experimental
     */
    readonly namespace: string;
    /**
     * (experimental) Name of this metric.
     *
     * @experimental
     */
    readonly metricName: string;
    /**
     * (experimental) Period of this metric.
     *
     * @experimental
     */
    readonly period: cdk.Duration;
    /**
     * (experimental) Statistic of this metric.
     *
     * @experimental
     */
    readonly statistic: string;
    /**
     * (experimental) Label for this metric when added to a Graph in a Dashboard.
     *
     * @experimental
     */
    readonly label?: string;
    /**
     * (experimental) The hex color code used when this metric is rendered on a graph.
     *
     * @experimental
     */
    readonly color?: string;
    /**
     * (experimental) Unit of the metric.
     *
     * @experimental
     */
    readonly unit?: Unit;
    /**
     * (experimental) Account which this metric comes from.
     *
     * @experimental
     */
    readonly account?: string;
    /**
     * (experimental) Region which this metric comes from.
     *
     * @experimental
     */
    readonly region?: string;
    /**
     * @experimental
     */
    constructor(props: MetricProps);
    /**
     * (experimental) Return a copy of Metric `with` properties changed.
     *
     * All properties except namespace and metricName can be changed.
     *
     * @param props The set of properties to change.
     * @experimental
     */
    with(props: MetricOptions): Metric;
    /**
     * (experimental) Attach the metric object to the given construct scope.
     *
     * Returns a Metric object that uses the account and region from the Stack
     * the given construct is defined in. If the metric is subsequently used
     * in a Dashboard or Alarm in a different Stack defined in a different
     * account or region, the appropriate 'region' and 'account' fields
     * will be added to it.
     *
     * If the scope we attach to is in an environment-agnostic stack,
     * nothing is done and the same Metric object is returned.
     *
     * @experimental
     */
    attachTo(scope: constructs.IConstruct): Metric;
    /**
     * (experimental) Inspect the details of the metric object.
     *
     * @experimental
     */
    toMetricConfig(): MetricConfig;
    /**
     * (deprecated) Turn this metric object into an alarm configuration.
     *
     * @deprecated use toMetricConfig()
     */
    toAlarmConfig(): MetricAlarmConfig;
    /**
     * (deprecated) Turn this metric object into a graph configuration.
     *
     * @deprecated use toMetricConfig()
     */
    toGraphConfig(): MetricGraphConfig;
    /**
     * (experimental) Make a new Alarm for this metric.
     *
     * Combines both properties that may adjust the metric (aggregation) as well
     * as alarm properties.
     *
     * @experimental
     */
    createAlarm(scope: Construct, id: string, props: CreateAlarmOptions): Alarm;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
    /**
     * Return the dimensions of this Metric as a list of Dimension.
     */
    private dimensionsAsList;
    private validateDimensions;
}
/**
 * (experimental) A math expression built with metric(s) emitted by a service.
 *
 * The math expression is a combination of an expression (x+y) and metrics to apply expression on.
 * It also contains metadata which is used only in graphs, such as color and label.
 * It makes sense to embed this in here, so that compound constructs can attach
 * that metadata to metrics they expose.
 *
 * This class does not represent a resource, so hence is not a construct. Instead,
 * MathExpression is an abstraction that makes it easy to specify metrics for use in both
 * alarms and graphs.
 *
 * @experimental
 */
export declare class MathExpression implements IMetric {
    /**
     * (experimental) The expression defining the metric.
     *
     * @experimental
     */
    readonly expression: string;
    /**
     * (experimental) The metrics used in the expression as KeyValuePair <id, metric>.
     *
     * @experimental
     */
    readonly usingMetrics: Record<string, IMetric>;
    /**
     * (experimental) Label for this metric when added to a Graph.
     *
     * @experimental
     */
    readonly label?: string;
    /**
     * (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The `Color` class has a set of standard colors that can be used here.
     *
     * @experimental
     */
    readonly color?: string;
    /**
     * (experimental) Aggregation period of this metric.
     *
     * @experimental
     */
    readonly period: cdk.Duration;
    /**
     * @experimental
     */
    constructor(props: MathExpressionProps);
    /**
     * (experimental) Return a copy of Metric with properties changed.
     *
     * All properties except namespace and metricName can be changed.
     *
     * @param props The set of properties to change.
     * @experimental
     */
    with(props: MathExpressionOptions): MathExpression;
    /**
     * (deprecated) Turn this metric object into an alarm configuration.
     *
     * @deprecated use toMetricConfig()
     */
    toAlarmConfig(): MetricAlarmConfig;
    /**
     * (deprecated) Turn this metric object into a graph configuration.
     *
     * @deprecated use toMetricConfig()
     */
    toGraphConfig(): MetricGraphConfig;
    /**
     * (experimental) Inspect the details of the metric object.
     *
     * @experimental
     */
    toMetricConfig(): MetricConfig;
    /**
     * (experimental) Make a new Alarm for this metric.
     *
     * Combines both properties that may adjust the metric (aggregation) as well
     * as alarm properties.
     *
     * @experimental
     */
    createAlarm(scope: Construct, id: string, props: CreateAlarmOptions): Alarm;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
    private validateNoIdConflicts;
}
/**
 * (experimental) Properties needed to make an alarm from a metric.
 *
 * @experimental
 */
export interface CreateAlarmOptions {
    /**
     * (deprecated) The period over which the specified statistic is applied.
     *
     * Cannot be used with `MathExpression` objects.
     *
     * @default - The period from the metric
     * @deprecated Use `metric.with({ period: ... })` to encode the period into the Metric object
     */
    readonly period?: cdk.Duration;
    /**
     * (deprecated) What function to use for aggregating.
     *
     * Can be one of the following:
     *
     * - "Minimum" | "min"
     * - "Maximum" | "max"
     * - "Average" | "avg"
     * - "Sum" | "sum"
     * - "SampleCount | "n"
     * - "pNN.NN"
     *
     * Cannot be used with `MathExpression` objects.
     *
     * @default - The statistic from the metric
     * @deprecated Use `metric.with({ statistic: ... })` to encode the period into the Metric object
     */
    readonly statistic?: string;
    /**
     * (experimental) Name of the alarm.
     *
     * @default Automatically generated name
     * @experimental
     */
    readonly alarmName?: string;
    /**
     * (experimental) Description for the alarm.
     *
     * @default No description
     * @experimental
     */
    readonly alarmDescription?: string;
    /**
     * (experimental) Comparison to use to check if metric is breaching.
     *
     * @default GreaterThanOrEqualToThreshold
     * @experimental
     */
    readonly comparisonOperator?: ComparisonOperator;
    /**
     * (experimental) The value against which the specified statistic is compared.
     *
     * @experimental
     */
    readonly threshold: number;
    /**
     * (experimental) The number of periods over which data is compared to the specified threshold.
     *
     * @experimental
     */
    readonly evaluationPeriods: number;
    /**
     * (experimental) Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant.
     *
     * Used only for alarms that are based on percentiles.
     *
     * @default - Not configured.
     * @experimental
     */
    readonly evaluateLowSampleCountPercentile?: string;
    /**
     * (experimental) Sets how this alarm is to handle missing data points.
     *
     * @default TreatMissingData.Missing
     * @experimental
     */
    readonly treatMissingData?: TreatMissingData;
    /**
     * (experimental) Whether the actions for this alarm are enabled.
     *
     * @default true
     * @experimental
     */
    readonly actionsEnabled?: boolean;
    /**
     * (experimental) The number of datapoints that must be breaching to trigger the alarm.
     *
     * This is used only if you are setting an "M
     * out of N" alarm. In that case, this value is the M. For more information, see Evaluating an Alarm in the Amazon
     * CloudWatch User Guide.
     *
     * @default ``evaluationPeriods``
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation
     * @experimental
     */
    readonly datapointsToAlarm?: number;
}
