"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogQueryWidget = exports.LogQueryVisualizationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const widget_1 = require("./widget");
/**
 * (experimental) Types of view.
 *
 * @experimental
 */
var LogQueryVisualizationType;
(function (LogQueryVisualizationType) {
    LogQueryVisualizationType["TABLE"] = "table";
    LogQueryVisualizationType["LINE"] = "line";
    LogQueryVisualizationType["STACKEDAREA"] = "stackedarea";
    LogQueryVisualizationType["BAR"] = "bar";
    LogQueryVisualizationType["PIE"] = "pie";
})(LogQueryVisualizationType = exports.LogQueryVisualizationType || (exports.LogQueryVisualizationType = {}));
/**
 * (experimental) Display query results from Logs Insights.
 *
 * @experimental
 */
class LogQueryWidget extends widget_1.ConcreteWidget {
    /**
     * @experimental
     */
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
        if (props.logGroupNames.length === 0) {
            throw new Error('Specify at least one log group name.');
        }
        if (!!props.queryString === !!props.queryLines) {
            throw new Error('Specify exactly one of \'queryString\' and \'queryLines\'');
        }
    }
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson() {
        const sources = this.props.logGroupNames.map(l => `SOURCE '${l}'`).join(' | ');
        const query = this.props.queryLines
            ? this.props.queryLines.join('\n| ')
            : this.props.queryString;
        const properties = {
            view: this.props.view ? this.props.view : LogQueryVisualizationType.TABLE,
            title: this.props.title,
            region: this.props.region || cdk.Aws.REGION,
            query: `${sources} | ${query}`,
        };
        // adding stacked property in case of LINE or STACKEDAREA
        if (this.props.view === LogQueryVisualizationType.LINE || this.props.view === LogQueryVisualizationType.STACKEDAREA) {
            // assign the right native view value. both types share the same value
            properties.view = 'timeSeries',
                properties.stacked = this.props.view === LogQueryVisualizationType.STACKEDAREA ? true : false;
        }
        return [{
                type: 'log',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: properties,
            }];
    }
}
exports.LogQueryWidget = LogQueryWidget;
_a = JSII_RTTI_SYMBOL_1;
LogQueryWidget[_a] = { fqn: "monocdk.aws_cloudwatch.LogQueryWidget", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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