"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Spacer = exports.Column = exports.Row = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const widget_1 = require("./widget");
// This file contains widgets that exist for layout purposes
/**
 * (experimental) A widget that contains other widgets in a horizontal row.
 *
 * Widgets will be laid out next to each other
 *
 * @experimental
 */
class Row {
    /**
     * @experimental
     */
    constructor(...widgets) {
        /**
         * Relative position of each widget inside this row
         */
        this.offsets = [];
        this.widgets = widgets;
        this.width = 0;
        this.height = 0;
        let x = 0;
        let y = 0;
        for (const widget of widgets) {
            // See if we need to horizontally wrap to add this widget
            if (x + widget.width > widget_1.GRID_WIDTH) {
                y = this.height;
                x = 0;
            }
            this.offsets.push({ x, y });
            this.width = Math.max(this.width, x + widget.width);
            this.height = Math.max(this.height, y + widget.height);
            x += widget.width;
        }
    }
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(x, y) {
        for (let i = 0; i < this.widgets.length; i++) {
            this.widgets[i].position(x + this.offsets[i].x, y + this.offsets[i].y);
        }
    }
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson() {
        const ret = [];
        for (const widget of this.widgets) {
            ret.push(...widget.toJson());
        }
        return ret;
    }
}
exports.Row = Row;
_a = JSII_RTTI_SYMBOL_1;
Row[_a] = { fqn: "monocdk.aws_cloudwatch.Row", version: "1.106.1" };
/**
 * (experimental) A widget that contains other widgets in a vertical column.
 *
 * Widgets will be laid out next to each other
 *
 * @experimental
 */
class Column {
    /**
     * @experimental
     */
    constructor(...widgets) {
        this.widgets = widgets;
        // There's no vertical wrapping so this one's a lot easier
        this.width = Math.max(...this.widgets.map(w => w.width));
        this.height = sum(...this.widgets.map(w => w.height));
    }
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(x, y) {
        let widgetY = y;
        for (const widget of this.widgets) {
            widget.position(x, widgetY);
            widgetY += widget.height;
        }
    }
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson() {
        const ret = [];
        for (const widget of this.widgets) {
            ret.push(...widget.toJson());
        }
        return ret;
    }
}
exports.Column = Column;
_b = JSII_RTTI_SYMBOL_1;
Column[_b] = { fqn: "monocdk.aws_cloudwatch.Column", version: "1.106.1" };
/**
 * (experimental) A widget that doesn't display anything but takes up space.
 *
 * @experimental
 */
class Spacer {
    /**
     * @experimental
     */
    constructor(props = {}) {
        this.width = props.width || 1;
        this.height = props.height || 1;
    }
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(_x, _y) {
        // Don't need to do anything, not a physical widget
    }
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson() {
        return [];
    }
}
exports.Spacer = Spacer;
_c = JSII_RTTI_SYMBOL_1;
Spacer[_c] = { fqn: "monocdk.aws_cloudwatch.Spacer", version: "1.106.1" };
/**
 * Return the sum of a list of numbers
 */
function sum(...xs) {
    let ret = 0;
    for (const x of xs) {
        ret += x;
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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