import { IWidget } from './widget';
/**
 * (experimental) A widget that contains other widgets in a horizontal row.
 *
 * Widgets will be laid out next to each other
 *
 * @experimental
 */
export declare class Row implements IWidget {
    /**
     * (experimental) The amount of horizontal grid units the widget will take up.
     *
     * @experimental
     */
    readonly width: number;
    /**
     * (experimental) The amount of vertical grid units the widget will take up.
     *
     * @experimental
     */
    readonly height: number;
    /**
     * List of contained widgets
     */
    private readonly widgets;
    /**
     * Relative position of each widget inside this row
     */
    private readonly offsets;
    /**
     * @experimental
     */
    constructor(...widgets: IWidget[]);
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(x: number, y: number): void;
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson(): any[];
}
/**
 * (experimental) A widget that contains other widgets in a vertical column.
 *
 * Widgets will be laid out next to each other
 *
 * @experimental
 */
export declare class Column implements IWidget {
    /**
     * (experimental) The amount of horizontal grid units the widget will take up.
     *
     * @experimental
     */
    readonly width: number;
    /**
     * (experimental) The amount of vertical grid units the widget will take up.
     *
     * @experimental
     */
    readonly height: number;
    /**
     * List of contained widgets
     */
    private readonly widgets;
    /**
     * @experimental
     */
    constructor(...widgets: IWidget[]);
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(x: number, y: number): void;
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson(): any[];
}
/**
 * (experimental) Props of the spacer.
 *
 * @experimental
 */
export interface SpacerProps {
    /**
     * (experimental) Width of the spacer.
     *
     * @default 1
     * @experimental
     */
    readonly width?: number;
    /**
     * (experimental) Height of the spacer.
     *
     * @default : 1
     * @experimental
     */
    readonly height?: number;
}
/**
 * (experimental) A widget that doesn't display anything but takes up space.
 *
 * @experimental
 */
export declare class Spacer implements IWidget {
    /**
     * (experimental) The amount of horizontal grid units the widget will take up.
     *
     * @experimental
     */
    readonly width: number;
    /**
     * (experimental) The amount of vertical grid units the widget will take up.
     *
     * @experimental
     */
    readonly height: number;
    /**
     * @experimental
     */
    constructor(props?: SpacerProps);
    /**
     * (experimental) Place the widget at a given position.
     *
     * @experimental
     */
    position(_x: number, _y: number): void;
    /**
     * (experimental) Return the widget JSON for use in the dashboard.
     *
     * @experimental
     */
    toJson(): any[];
}
