import { Construct } from 'constructs';
import { AlarmBase, IAlarm, IAlarmRule } from './alarm-base';
/**
 * (experimental) Properties for creating a Composite Alarm.
 *
 * @experimental
 */
export interface CompositeAlarmProps {
    /**
     * (experimental) Whether the actions for this alarm are enabled.
     *
     * @default true
     * @experimental
     */
    readonly actionsEnabled?: boolean;
    /**
     * (experimental) Description for the alarm.
     *
     * @default No description
     * @experimental
     */
    readonly alarmDescription?: string;
    /**
     * (experimental) Name of the alarm.
     *
     * @default Automatically generated name
     * @experimental
     */
    readonly compositeAlarmName?: string;
    /**
     * (experimental) Expression that specifies which other alarms are to be evaluated to determine this composite alarm's state.
     *
     * @experimental
     */
    readonly alarmRule: IAlarmRule;
}
/**
 * (experimental) A Composite Alarm based on Alarm Rule.
 *
 * @experimental
 */
export declare class CompositeAlarm extends AlarmBase {
    /**
     * (experimental) Import an existing CloudWatch composite alarm provided an Name.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param compositeAlarmName Composite Alarm Name.
     * @experimental
     */
    static fromCompositeAlarmName(scope: Construct, id: string, compositeAlarmName: string): IAlarm;
    /**
     * (experimental) Import an existing CloudWatch composite alarm provided an ARN.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param compositeAlarmArn Composite Alarm ARN (i.e. arn:aws:cloudwatch:<region>:<account-id>:alarm/CompositeAlarmName).
     * @experimental
     */
    static fromCompositeAlarmArn(scope: Construct, id: string, compositeAlarmArn: string): IAlarm;
    /**
     * (experimental) ARN of this alarm.
     *
     * @experimental
     * @attribute true
     */
    readonly alarmArn: string;
    /**
     * (experimental) Name of this alarm.
     *
     * @experimental
     * @attribute true
     */
    readonly alarmName: string;
    private readonly alarmRule;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CompositeAlarmProps);
    private generateUniqueId;
}
