import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::CloudWatch::Alarm`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 */
export interface CfnAlarmProps {
    /**
     * `AWS::CloudWatch::Alarm.ComparisonOperator`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-comparisonoperator
     */
    readonly comparisonOperator: string;
    /**
     * `AWS::CloudWatch::Alarm.EvaluationPeriods`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluationperiods
     */
    readonly evaluationPeriods: number;
    /**
     * `AWS::CloudWatch::Alarm.ActionsEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
     */
    readonly actionsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::Alarm.AlarmActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmactions
     */
    readonly alarmActions?: string[];
    /**
     * `AWS::CloudWatch::Alarm.AlarmDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmdescription
     */
    readonly alarmDescription?: string;
    /**
     * `AWS::CloudWatch::Alarm.AlarmName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmname
     */
    readonly alarmName?: string;
    /**
     * `AWS::CloudWatch::Alarm.DatapointsToAlarm`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm
     */
    readonly datapointsToAlarm?: number;
    /**
     * `AWS::CloudWatch::Alarm.Dimensions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
     */
    readonly dimensions?: Array<CfnAlarm.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::Alarm.EvaluateLowSampleCountPercentile`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluatelowsamplecountpercentile
     */
    readonly evaluateLowSampleCountPercentile?: string;
    /**
     * `AWS::CloudWatch::Alarm.ExtendedStatistic`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-extendedstatistic
     */
    readonly extendedStatistic?: string;
    /**
     * `AWS::CloudWatch::Alarm.InsufficientDataActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-insufficientdataactions
     */
    readonly insufficientDataActions?: string[];
    /**
     * `AWS::CloudWatch::Alarm.MetricName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-metricname
     */
    readonly metricName?: string;
    /**
     * `AWS::CloudWatch::Alarm.Metrics`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
     */
    readonly metrics?: Array<CfnAlarm.MetricDataQueryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::Alarm.Namespace`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-namespace
     */
    readonly namespace?: string;
    /**
     * `AWS::CloudWatch::Alarm.OKActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-okactions
     */
    readonly okActions?: string[];
    /**
     * `AWS::CloudWatch::Alarm.Period`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-period
     */
    readonly period?: number;
    /**
     * `AWS::CloudWatch::Alarm.Statistic`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-statistic
     */
    readonly statistic?: string;
    /**
     * `AWS::CloudWatch::Alarm.Threshold`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-threshold
     */
    readonly threshold?: number;
    /**
     * `AWS::CloudWatch::Alarm.ThresholdMetricId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dynamic-threshold
     */
    readonly thresholdMetricId?: string;
    /**
     * `AWS::CloudWatch::Alarm.TreatMissingData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-treatmissingdata
     */
    readonly treatMissingData?: string;
    /**
     * `AWS::CloudWatch::Alarm.Unit`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-unit
     */
    readonly unit?: string;
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::Alarm
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 */
export declare class CfnAlarm extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::Alarm";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAlarm;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CloudWatch::Alarm.ComparisonOperator`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-comparisonoperator
     */
    comparisonOperator: string;
    /**
     * `AWS::CloudWatch::Alarm.EvaluationPeriods`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluationperiods
     */
    evaluationPeriods: number;
    /**
     * `AWS::CloudWatch::Alarm.ActionsEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
     */
    actionsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::Alarm.AlarmActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmactions
     */
    alarmActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::Alarm.AlarmDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmdescription
     */
    alarmDescription: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.AlarmName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmname
     */
    alarmName: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.DatapointsToAlarm`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm
     */
    datapointsToAlarm: number | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Dimensions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
     */
    dimensions: Array<CfnAlarm.DimensionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::Alarm.EvaluateLowSampleCountPercentile`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluatelowsamplecountpercentile
     */
    evaluateLowSampleCountPercentile: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.ExtendedStatistic`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-extendedstatistic
     */
    extendedStatistic: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.InsufficientDataActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-insufficientdataactions
     */
    insufficientDataActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::Alarm.MetricName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-metricname
     */
    metricName: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Metrics`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
     */
    metrics: Array<CfnAlarm.MetricDataQueryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Namespace`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-namespace
     */
    namespace: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.OKActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-okactions
     */
    okActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Period`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-period
     */
    period: number | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Statistic`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-statistic
     */
    statistic: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Threshold`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-threshold
     */
    threshold: number | undefined;
    /**
     * `AWS::CloudWatch::Alarm.ThresholdMetricId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dynamic-threshold
     */
    thresholdMetricId: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.TreatMissingData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-treatmissingdata
     */
    treatMissingData: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Unit`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-unit
     */
    unit: string | undefined;
    /**
     * Create a new `AWS::CloudWatch::Alarm`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAlarmProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::Alarm
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 */
export declare namespace CfnAlarm {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html
     */
    interface DimensionProperty {
        /**
         * `CfnAlarm.DimensionProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html#cfn-cloudwatch-alarm-dimension-name
         */
        readonly name: string;
        /**
         * `CfnAlarm.DimensionProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html#cfn-cloudwatch-alarm-dimension-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::Alarm
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 */
export declare namespace CfnAlarm {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html
     */
    interface MetricProperty {
        /**
         * `CfnAlarm.MetricProperty.Dimensions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-dimensions
         */
        readonly dimensions?: Array<CfnAlarm.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAlarm.MetricProperty.MetricName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-metricname
         */
        readonly metricName?: string;
        /**
         * `CfnAlarm.MetricProperty.Namespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-namespace
         */
        readonly namespace?: string;
    }
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::Alarm
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 */
export declare namespace CfnAlarm {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html
     */
    interface MetricDataQueryProperty {
        /**
         * `CfnAlarm.MetricDataQueryProperty.Expression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-expression
         */
        readonly expression?: string;
        /**
         * `CfnAlarm.MetricDataQueryProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-id
         */
        readonly id: string;
        /**
         * `CfnAlarm.MetricDataQueryProperty.Label`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-label
         */
        readonly label?: string;
        /**
         * `CfnAlarm.MetricDataQueryProperty.MetricStat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-metricstat
         */
        readonly metricStat?: CfnAlarm.MetricStatProperty | cdk.IResolvable;
        /**
         * `CfnAlarm.MetricDataQueryProperty.Period`.
         *
         * @external
         */
        readonly period?: number;
        /**
         * `CfnAlarm.MetricDataQueryProperty.ReturnData`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-returndata
         */
        readonly returnData?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::Alarm
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 */
export declare namespace CfnAlarm {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html
     */
    interface MetricStatProperty {
        /**
         * `CfnAlarm.MetricStatProperty.Metric`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-metric
         */
        readonly metric: CfnAlarm.MetricProperty | cdk.IResolvable;
        /**
         * `CfnAlarm.MetricStatProperty.Period`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-period
         */
        readonly period: number;
        /**
         * `CfnAlarm.MetricStatProperty.Stat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-stat
         */
        readonly stat: string;
        /**
         * `CfnAlarm.MetricStatProperty.Unit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-unit
         */
        readonly unit?: string;
    }
}
/**
 * Properties for defining a `AWS::CloudWatch::AnomalyDetector`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 */
export interface CfnAnomalyDetectorProps {
    /**
     * `AWS::CloudWatch::AnomalyDetector.MetricName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metricname
     */
    readonly metricName: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Namespace`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-namespace
     */
    readonly namespace: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Stat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-stat
     */
    readonly stat: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-configuration
     */
    readonly configuration?: CfnAnomalyDetector.ConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Dimensions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-dimensions
     */
    readonly dimensions?: Array<CfnAnomalyDetector.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CloudWatch::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 */
export declare class CfnAnomalyDetector extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::AnomalyDetector";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAnomalyDetector;
    /**
     * `AWS::CloudWatch::AnomalyDetector.MetricName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metricname
     */
    metricName: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Namespace`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-namespace
     */
    namespace: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Stat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-stat
     */
    stat: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Configuration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-configuration
     */
    configuration: CfnAnomalyDetector.ConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Dimensions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-dimensions
     */
    dimensions: Array<CfnAnomalyDetector.DimensionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::CloudWatch::AnomalyDetector`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAnomalyDetectorProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudWatch::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-configuration.html
     */
    interface ConfigurationProperty {
        /**
         * `CfnAnomalyDetector.ConfigurationProperty.ExcludedTimeRanges`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-configuration.html#cfn-cloudwatch-anomalydetector-configuration-excludedtimeranges
         */
        readonly excludedTimeRanges?: Array<CfnAnomalyDetector.RangeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.ConfigurationProperty.MetricTimeZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-configuration.html#cfn-cloudwatch-anomalydetector-configuration-metrictimezone
         */
        readonly metricTimeZone?: string;
    }
}
/**
 * A CloudFormation `AWS::CloudWatch::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-dimension.html
     */
    interface DimensionProperty {
        /**
         * `CfnAnomalyDetector.DimensionProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-dimension.html#cfn-cloudwatch-anomalydetector-dimension-name
         */
        readonly name: string;
        /**
         * `CfnAnomalyDetector.DimensionProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-dimension.html#cfn-cloudwatch-anomalydetector-dimension-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::CloudWatch::AnomalyDetector`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::AnomalyDetector
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-range.html
     */
    interface RangeProperty {
        /**
         * `CfnAnomalyDetector.RangeProperty.EndTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-range.html#cfn-cloudwatch-anomalydetector-range-endtime
         */
        readonly endTime: string;
        /**
         * `CfnAnomalyDetector.RangeProperty.StartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-range.html#cfn-cloudwatch-anomalydetector-range-starttime
         */
        readonly startTime: string;
    }
}
/**
 * Properties for defining a `AWS::CloudWatch::CompositeAlarm`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html
 */
export interface CfnCompositeAlarmProps {
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmname
     */
    readonly alarmName: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmRule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmrule
     */
    readonly alarmRule: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.ActionsEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionsenabled
     */
    readonly actionsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmactions
     */
    readonly alarmActions?: string[];
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmdescription
     */
    readonly alarmDescription?: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.InsufficientDataActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-insufficientdataactions
     */
    readonly insufficientDataActions?: string[];
    /**
     * `AWS::CloudWatch::CompositeAlarm.OKActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-okactions
     */
    readonly okActions?: string[];
}
/**
 * A CloudFormation `AWS::CloudWatch::CompositeAlarm`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::CompositeAlarm
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html
 */
export declare class CfnCompositeAlarm extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::CompositeAlarm";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCompositeAlarm;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmname
     */
    alarmName: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmRule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmrule
     */
    alarmRule: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.ActionsEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionsenabled
     */
    actionsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmactions
     */
    alarmActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmdescription
     */
    alarmDescription: string | undefined;
    /**
     * `AWS::CloudWatch::CompositeAlarm.InsufficientDataActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-insufficientdataactions
     */
    insufficientDataActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::CompositeAlarm.OKActions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-okactions
     */
    okActions: string[] | undefined;
    /**
     * Create a new `AWS::CloudWatch::CompositeAlarm`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCompositeAlarmProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudWatch::Dashboard`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html
 */
export interface CfnDashboardProps {
    /**
     * `AWS::CloudWatch::Dashboard.DashboardBody`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardbody
     */
    readonly dashboardBody: string;
    /**
     * `AWS::CloudWatch::Dashboard.DashboardName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardname
     */
    readonly dashboardName?: string;
}
/**
 * A CloudFormation `AWS::CloudWatch::Dashboard`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::Dashboard
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html
 */
export declare class CfnDashboard extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::Dashboard";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDashboard;
    /**
     * `AWS::CloudWatch::Dashboard.DashboardBody`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardbody
     */
    dashboardBody: string;
    /**
     * `AWS::CloudWatch::Dashboard.DashboardName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardname
     */
    dashboardName: string | undefined;
    /**
     * Create a new `AWS::CloudWatch::Dashboard`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDashboardProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudWatch::InsightRule`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html
 */
export interface CfnInsightRuleProps {
    /**
     * `AWS::CloudWatch::InsightRule.RuleBody`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulebody
     */
    readonly ruleBody: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulename
     */
    readonly ruleName: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleState`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulestate
     */
    readonly ruleState: string;
    /**
     * `AWS::CloudWatch::InsightRule.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-tags
     */
    readonly tags?: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CloudWatch::InsightRule`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::InsightRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html
 */
export declare class CfnInsightRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::InsightRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInsightRule;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute RuleName
     */
    readonly attrRuleName: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleBody`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulebody
     */
    ruleBody: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulename
     */
    ruleName: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleState`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulestate
     */
    ruleState: string;
    /**
     * `AWS::CloudWatch::InsightRule.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CloudWatch::InsightRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInsightRuleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudWatch::MetricStream`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html
 */
export interface CfnMetricStreamProps {
    /**
     * `AWS::CloudWatch::MetricStream.FirehoseArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-firehosearn
     */
    readonly firehoseArn: string;
    /**
     * `AWS::CloudWatch::MetricStream.OutputFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-outputformat
     */
    readonly outputFormat: string;
    /**
     * `AWS::CloudWatch::MetricStream.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::CloudWatch::MetricStream.ExcludeFilters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-excludefilters
     */
    readonly excludeFilters?: Array<CfnMetricStream.MetricStreamFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::MetricStream.IncludeFilters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-includefilters
     */
    readonly includeFilters?: Array<CfnMetricStream.MetricStreamFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::MetricStream.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-name
     */
    readonly name?: string;
    /**
     * `AWS::CloudWatch::MetricStream.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CloudWatch::MetricStream`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::MetricStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html
 */
export declare class CfnMetricStream extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::MetricStream";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMetricStream;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreationDate
     */
    readonly attrCreationDate: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdateDate
     */
    readonly attrLastUpdateDate: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * `AWS::CloudWatch::MetricStream.FirehoseArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-firehosearn
     */
    firehoseArn: string;
    /**
     * `AWS::CloudWatch::MetricStream.OutputFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-outputformat
     */
    outputFormat: string;
    /**
     * `AWS::CloudWatch::MetricStream.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-rolearn
     */
    roleArn: string;
    /**
     * `AWS::CloudWatch::MetricStream.ExcludeFilters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-excludefilters
     */
    excludeFilters: Array<CfnMetricStream.MetricStreamFilterProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::MetricStream.IncludeFilters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-includefilters
     */
    includeFilters: Array<CfnMetricStream.MetricStreamFilterProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::MetricStream.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-name
     */
    name: string | undefined;
    /**
     * `AWS::CloudWatch::MetricStream.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html#cfn-cloudwatch-metricstream-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CloudWatch::MetricStream`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMetricStreamProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudWatch::MetricStream`.
 *
 * @external
 * @cloudformationResource AWS::CloudWatch::MetricStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-metricstream.html
 */
export declare namespace CfnMetricStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-metricstream-metricstreamfilter.html
     */
    interface MetricStreamFilterProperty {
        /**
         * `CfnMetricStream.MetricStreamFilterProperty.Namespace`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-metricstream-metricstreamfilter.html#cfn-cloudwatch-metricstream-metricstreamfilter-namespace
         */
        readonly namespace: string;
    }
}
