import { Construct } from 'constructs';
import { IAlarmAction } from './alarm-action';
import { AlarmBase, IAlarm } from './alarm-base';
import { HorizontalAnnotation } from './graph';
import { CreateAlarmOptions } from './metric';
import { IMetric } from './metric-types';
/**
 * (experimental) Properties for Alarms.
 *
 * @experimental
 */
export interface AlarmProps extends CreateAlarmOptions {
    /**
     * (experimental) The metric to add the alarm on.
     *
     * Metric objects can be obtained from most resources, or you can construct
     * custom Metric objects by instantiating one.
     *
     * @experimental
     */
    readonly metric: IMetric;
}
/**
 * (experimental) Comparison operator for evaluating alarms.
 *
 * @experimental
 */
export declare enum ComparisonOperator {
    /**
     * (experimental) Specified statistic is greater than or equal to the threshold.
     *
     * @experimental
     */
    GREATER_THAN_OR_EQUAL_TO_THRESHOLD = "GreaterThanOrEqualToThreshold",
    /**
     * (experimental) Specified statistic is strictly greater than the threshold.
     *
     * @experimental
     */
    GREATER_THAN_THRESHOLD = "GreaterThanThreshold",
    /**
     * (experimental) Specified statistic is strictly less than the threshold.
     *
     * @experimental
     */
    LESS_THAN_THRESHOLD = "LessThanThreshold",
    /**
     * (experimental) Specified statistic is less than or equal to the threshold.
     *
     * @experimental
     */
    LESS_THAN_OR_EQUAL_TO_THRESHOLD = "LessThanOrEqualToThreshold",
    /**
     * (experimental) Specified statistic is lower than or greater than the anomaly model band.
     *
     * Used only for alarms based on anomaly detection models
     *
     * @experimental
     */
    LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD = "LessThanLowerOrGreaterThanUpperThreshold",
    /**
     * (experimental) Specified statistic is greater than the anomaly model band.
     *
     * Used only for alarms based on anomaly detection models
     *
     * @experimental
     */
    GREATER_THAN_UPPER_THRESHOLD = "GreaterThanUpperThreshold",
    /**
     * (experimental) Specified statistic is lower than the anomaly model band.
     *
     * Used only for alarms based on anomaly detection models
     *
     * @experimental
     */
    LESS_THAN_LOWER_THRESHOLD = "LessThanLowerThreshold"
}
/**
 * (experimental) Specify how missing data points are treated during alarm evaluation.
 *
 * @experimental
 */
export declare enum TreatMissingData {
    /**
     * (experimental) Missing data points are treated as breaching the threshold.
     *
     * @experimental
     */
    BREACHING = "breaching",
    /**
     * (experimental) Missing data points are treated as being within the threshold.
     *
     * @experimental
     */
    NOT_BREACHING = "notBreaching",
    /**
     * (experimental) The current alarm state is maintained.
     *
     * @experimental
     */
    IGNORE = "ignore",
    /**
     * (experimental) The alarm does not consider missing data points when evaluating whether to change state.
     *
     * @experimental
     */
    MISSING = "missing"
}
/**
 * (experimental) An alarm on a CloudWatch metric.
 *
 * @experimental
 */
export declare class Alarm extends AlarmBase {
    /**
     * (experimental) Import an existing CloudWatch alarm provided an ARN.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param alarmArn Alarm ARN (i.e. arn:aws:cloudwatch:<region>:<account-id>:alarm:Foo).
     * @experimental
     */
    static fromAlarmArn(scope: Construct, id: string, alarmArn: string): IAlarm;
    /**
     * (experimental) ARN of this alarm.
     *
     * @experimental
     * @attribute true
     */
    readonly alarmArn: string;
    /**
     * (experimental) Name of this alarm.
     *
     * @experimental
     * @attribute true
     */
    readonly alarmName: string;
    /**
     * (experimental) The metric object this alarm was based on.
     *
     * @experimental
     */
    readonly metric: IMetric;
    /**
     * This metric as an annotation
     */
    private readonly annotation;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AlarmProps);
    /**
     * (experimental) Turn this alarm into a horizontal annotation.
     *
     * This is useful if you want to represent an Alarm in a non-AlarmWidget.
     * An `AlarmWidget` can directly show an alarm, but it can only show a
     * single alarm and no other metrics. Instead, you can convert the alarm to
     * a HorizontalAnnotation and add it as an annotation to another graph.
     *
     * This might be useful if:
     *
     * - You want to show multiple alarms inside a single graph, for example if
     *    you have both a "small margin/long period" alarm as well as a
     *    "large margin/short period" alarm.
     *
     * - You want to show an Alarm line in a graph with multiple metrics in it.
     *
     * @experimental
     */
    toAnnotation(): HorizontalAnnotation;
    /**
     * (experimental) Trigger this action if the alarm fires.
     *
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     *
     * @experimental
     */
    addAlarmAction(...actions: IAlarmAction[]): void;
    private validateActionArn;
    private renderMetric;
    /**
     * Validate that if a region and account are in the given stat config, they match the Alarm
     */
    private validateMetricStat;
}
