import { IAlarm, IAlarmRule } from './alarm-base';
/**
 * (experimental) Enumeration indicates state of Alarm used in building Alarm Rule.
 *
 * @experimental
 */
export declare enum AlarmState {
    /**
     * (experimental) State indicates resource is in ALARM.
     *
     * @experimental
     */
    ALARM = "ALARM",
    /**
     * (experimental) State indicates resource is not in ALARM.
     *
     * @experimental
     */
    OK = "OK",
    /**
     * (experimental) State indicates there is not enough data to determine is resource is in ALARM.
     *
     * @experimental
     */
    INSUFFICIENT_DATA = "INSUFFICIENT_DATA"
}
/**
 * (experimental) Class with static functions to build AlarmRule for Composite Alarms.
 *
 * @experimental
 */
export declare class AlarmRule {
    /**
     * (experimental) function to join all provided AlarmRules with AND operator.
     *
     * @param operands IAlarmRules to be joined with AND operator.
     * @experimental
     */
    static allOf(...operands: IAlarmRule[]): IAlarmRule;
    /**
     * (experimental) function to join all provided AlarmRules with OR operator.
     *
     * @param operands IAlarmRules to be joined with OR operator.
     * @experimental
     */
    static anyOf(...operands: IAlarmRule[]): IAlarmRule;
    /**
     * (experimental) function to wrap provided AlarmRule in NOT operator.
     *
     * @param operand IAlarmRule to be wrapped in NOT operator.
     * @experimental
     */
    static not(operand: IAlarmRule): IAlarmRule;
    /**
     * (experimental) function to build TRUE/FALSE intent for Rule Expression.
     *
     * @param value boolean value to be used in rule expression.
     * @experimental
     */
    static fromBoolean(value: boolean): IAlarmRule;
    /**
     * (experimental) function to build Rule Expression for given IAlarm and AlarmState.
     *
     * @param alarm IAlarm to be used in Rule Expression.
     * @param alarmState AlarmState to be used in Rule Expression.
     * @experimental
     */
    static fromAlarm(alarm: IAlarm, alarmState: AlarmState): IAlarmRule;
    /**
     * (experimental) function to build Rule Expression for given Alarm Rule string.
     *
     * @param alarmRule string to be used in Rule Expression.
     * @experimental
     */
    static fromString(alarmRule: string): IAlarmRule;
    private static concat;
}
