import { IResource, Resource } from "../../core";
import { IAlarmAction } from './alarm-action';
/**
 * (experimental) Interface for Alarm Rule.
 *
 * @experimental
 */
export interface IAlarmRule {
    /**
     * (experimental) serialized representation of Alarm Rule to be used when building the Composite Alarm resource.
     *
     * @experimental
     */
    renderAlarmRule(): string;
}
/**
 * (experimental) Represents a CloudWatch Alarm.
 *
 * @experimental
 */
export interface IAlarm extends IAlarmRule, IResource {
    /**
     * (experimental) Alarm ARN (i.e. arn:aws:cloudwatch:<region>:<account-id>:alarm:Foo).
     *
     * @experimental
     * @attribute true
     */
    readonly alarmArn: string;
    /**
     * (experimental) Name of the alarm.
     *
     * @experimental
     * @attribute true
     */
    readonly alarmName: string;
}
/**
 * (experimental) The base class for Alarm and CompositeAlarm resources.
 *
 * @experimental
 */
export declare abstract class AlarmBase extends Resource implements IAlarm {
    /**
     * (experimental) Alarm ARN (i.e. arn:aws:cloudwatch:<region>:<account-id>:alarm:Foo).
     *
     * @experimental
     * @attribute true
     */
    abstract readonly alarmArn: string;
    /**
     * (experimental) Name of the alarm.
     *
     * @experimental
     */
    abstract readonly alarmName: string;
    /**
     * @experimental
     */
    protected alarmActionArns?: string[];
    /**
     * @experimental
     */
    protected insufficientDataActionArns?: string[];
    /**
     * @experimental
     */
    protected okActionArns?: string[];
    /**
     * (experimental) AlarmRule indicating ALARM state for Alarm.
     *
     * @experimental
     */
    renderAlarmRule(): string;
    /**
     * (experimental) Trigger this action if the alarm fires.
     *
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     *
     * @experimental
     */
    addAlarmAction(...actions: IAlarmAction[]): void;
    /**
     * (experimental) Trigger this action if there is insufficient data to evaluate the alarm.
     *
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     *
     * @experimental
     */
    addInsufficientDataAction(...actions: IAlarmAction[]): void;
    /**
     * (experimental) Trigger this action if the alarm returns from breaching state into ok state.
     *
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     *
     * @experimental
     */
    addOkAction(...actions: IAlarmAction[]): void;
}
