"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2Action = exports.Ec2InstanceAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Types of EC2 actions available.
 *
 * @experimental
 */
var Ec2InstanceAction;
(function (Ec2InstanceAction) {
    Ec2InstanceAction["STOP"] = "stop";
    Ec2InstanceAction["TERMINATE"] = "terminate";
    Ec2InstanceAction["RECOVER"] = "recover";
    Ec2InstanceAction["REBOOT"] = "reboot";
})(Ec2InstanceAction = exports.Ec2InstanceAction || (exports.Ec2InstanceAction = {}));
/**
 * (experimental) Use an EC2 action as an Alarm action.
 *
 * @experimental
 */
class Ec2Action {
    /**
     * @experimental
     */
    constructor(instanceAction) {
        this.ec2Action = instanceAction;
    }
    /**
     * (experimental) Returns an alarm action configuration to use an EC2 action as an alarm action.
     *
     * @experimental
     */
    bind(_scope, _alarm) {
        return { alarmActionArn: `arn:aws:automate:${core_1.Stack.of(_scope).region}:ec2:${this.ec2Action}` };
    }
}
exports.Ec2Action = Ec2Action;
_a = JSII_RTTI_SYMBOL_1;
Ec2Action[_a] = { fqn: "monocdk.aws_cloudwatch_actions.Ec2Action", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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