import * as cloudwatch from "../../aws-cloudwatch";
import { Construct } from "../../core";
/**
 * (experimental) Types of EC2 actions available.
 *
 * @experimental
 */
export declare enum Ec2InstanceAction {
    /**
     * (experimental) Stop the instance.
     *
     * @experimental
     */
    STOP = "stop",
    /**
     * (experimental) Terminatethe instance.
     *
     * @experimental
     */
    TERMINATE = "terminate",
    /**
     * (experimental) Recover the instance.
     *
     * @experimental
     */
    RECOVER = "recover",
    /**
     * (experimental) Reboot the instance.
     *
     * @experimental
     */
    REBOOT = "reboot"
}
/**
 * (experimental) Use an EC2 action as an Alarm action.
 *
 * @experimental
 */
export declare class Ec2Action implements cloudwatch.IAlarmAction {
    private ec2Action;
    /**
     * @experimental
     */
    constructor(instanceAction: Ec2InstanceAction);
    /**
     * (experimental) Returns an alarm action configuration to use an EC2 action as an alarm action.
     *
     * @experimental
     */
    bind(_scope: Construct, _alarm: cloudwatch.IAlarm): cloudwatch.AlarmActionConfig;
}
