import * as certificatemanager from "../../aws-certificatemanager";
import * as lambda from "../../aws-lambda";
import * as s3 from "../../aws-s3";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { CfnDistribution } from './cloudfront.generated';
import { HttpVersion, IDistribution, LambdaEdgeEventType, OriginProtocolPolicy, PriceClass, ViewerProtocolPolicy, SSLMethod, SecurityPolicyProtocol } from './distribution';
import { GeoRestriction } from './geo-restriction';
import { IKeyGroup } from './key-group';
import { IOriginAccessIdentity } from './origin-access-identity';
/**
 * (experimental) HTTP status code to failover to second origin.
 *
 * @experimental
 */
export declare enum FailoverStatusCode {
    /**
     * (experimental) Forbidden (403).
     *
     * @experimental
     */
    FORBIDDEN = 403,
    /**
     * (experimental) Not found (404).
     *
     * @experimental
     */
    NOT_FOUND = 404,
    /**
     * (experimental) Internal Server Error (500).
     *
     * @experimental
     */
    INTERNAL_SERVER_ERROR = 500,
    /**
     * (experimental) Bad Gateway (502).
     *
     * @experimental
     */
    BAD_GATEWAY = 502,
    /**
     * (experimental) Service Unavailable (503).
     *
     * @experimental
     */
    SERVICE_UNAVAILABLE = 503,
    /**
     * (experimental) Gateway Timeout (504).
     *
     * @experimental
     */
    GATEWAY_TIMEOUT = 504
}
/**
 * (deprecated) Configuration for custom domain names.
 *
 * CloudFront can use a custom domain that you provide instead of a
 * "cloudfront.net" domain. To use this feature you must provide the list of
 * additional domains, and the ACM Certificate that CloudFront should use for
 * these additional domains.
 *
 * @deprecated see {@link CloudFrontWebDistributionProps#viewerCertificate} with {@link ViewerCertificate#acmCertificate}
 */
export interface AliasConfiguration {
    /**
     * (deprecated) ARN of an AWS Certificate Manager (ACM) certificate.
     *
     * @deprecated
     */
    readonly acmCertRef: string;
    /**
     * (deprecated) Domain names on the certificate.
     *
     * Both main domain name and Subject Alternative Names.
     *
     * @deprecated
     */
    readonly names: string[];
    /**
     * (deprecated) How CloudFront should serve HTTPS requests.
     *
     * See the notes on SSLMethod if you wish to use other SSL termination types.
     *
     * @default SSLMethod.SNI
     * @see https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ViewerCertificate.html
     * @deprecated
     */
    readonly sslMethod?: SSLMethod;
    /**
     * (deprecated) The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
     *
     * CloudFront serves your objects only to browsers or devices that support at
     * least the SSL version that you specify.
     *
     * @default - SSLv3 if sslMethod VIP, TLSv1 if sslMethod SNI
     * @deprecated
     */
    readonly securityPolicy?: SecurityPolicyProtocol;
}
/**
 * (experimental) Logging configuration for incoming requests.
 *
 * @experimental
 */
export interface LoggingConfiguration {
    /**
     * (experimental) Bucket to log requests to.
     *
     * @default - A logging bucket is automatically created.
     * @experimental
     */
    readonly bucket?: s3.IBucket;
    /**
     * (experimental) Whether to include the cookies in the logs.
     *
     * @default false
     * @experimental
     */
    readonly includeCookies?: boolean;
    /**
     * (experimental) Where in the bucket to store logs.
     *
     * @default - No prefix.
     * @experimental
     */
    readonly prefix?: string;
}
/**
 * (experimental) A source configuration is a wrapper for CloudFront origins and behaviors.
 *
 * An origin is what CloudFront will "be in front of" - that is, CloudFront will pull it's assets from an origin.
 *
 * If you're using s3 as a source - pass the `s3Origin` property, otherwise, pass the `customOriginSource` property.
 *
 * One or the other must be passed, and it is invalid to pass both in the same SourceConfiguration.
 *
 * @experimental
 */
export interface SourceConfiguration {
    /**
     * (experimental) The number of times that CloudFront attempts to connect to the origin.
     *
     * You can specify 1, 2, or 3 as the number of attempts.
     *
     * @default 3
     * @experimental
     */
    readonly connectionAttempts?: number;
    /**
     * (experimental) The number of seconds that CloudFront waits when trying to establish a connection to the origin.
     *
     * You can specify a number of seconds between 1 and 10 (inclusive).
     *
     * @default cdk.Duration.seconds(10)
     * @experimental
     */
    readonly connectionTimeout?: cdk.Duration;
    /**
     * (experimental) An s3 origin source - if you're using s3 for your assets.
     *
     * @experimental
     */
    readonly s3OriginSource?: S3OriginConfig;
    /**
     * (experimental) A custom origin source - for all non-s3 sources.
     *
     * @experimental
     */
    readonly customOriginSource?: CustomOriginConfig;
    /**
     * (experimental) An s3 origin source for failover in case the s3OriginSource returns invalid status code.
     *
     * @default - no failover configuration
     * @experimental
     */
    readonly failoverS3OriginSource?: S3OriginConfig;
    /**
     * (experimental) A custom origin source for failover in case the s3OriginSource returns invalid status code.
     *
     * @default - no failover configuration
     * @experimental
     */
    readonly failoverCustomOriginSource?: CustomOriginConfig;
    /**
     * (experimental) HTTP status code to failover to second origin.
     *
     * @default [500, 502, 503, 504]
     * @experimental
     */
    readonly failoverCriteriaStatusCodes?: FailoverStatusCode[];
    /**
     * (experimental) The behaviors associated with this source.
     *
     * At least one (default) behavior must be included.
     *
     * @experimental
     */
    readonly behaviors: Behavior[];
    /**
     * (deprecated) The relative path to the origin root to use for sources.
     *
     * @default /
     * @deprecated Use originPath on s3OriginSource or customOriginSource
     */
    readonly originPath?: string;
    /**
     * (deprecated) Any additional headers to pass to the origin.
     *
     * @default - No additional headers are passed.
     * @deprecated Use originHeaders on s3OriginSource or customOriginSource
     */
    readonly originHeaders?: {
        [key: string]: string;
    };
}
/**
 * (experimental) A custom origin configuration.
 *
 * @experimental
 */
export interface CustomOriginConfig {
    /**
     * (experimental) The domain name of the custom origin.
     *
     * Should not include the path - that should be in the parent SourceConfiguration
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) The origin HTTP port.
     *
     * @default 80
     * @experimental
     */
    readonly httpPort?: number;
    /**
     * (experimental) The origin HTTPS port.
     *
     * @default 443
     * @experimental
     */
    readonly httpsPort?: number;
    /**
     * (experimental) The keep alive timeout when making calls in seconds.
     *
     * @default Duration.seconds(5)
     * @experimental
     */
    readonly originKeepaliveTimeout?: cdk.Duration;
    /**
     * (experimental) The protocol (http or https) policy to use when interacting with the origin.
     *
     * @default OriginProtocolPolicy.HttpsOnly
     * @experimental
     */
    readonly originProtocolPolicy?: OriginProtocolPolicy;
    /**
     * (experimental) The read timeout when calling the origin in seconds.
     *
     * @default Duration.seconds(30)
     * @experimental
     */
    readonly originReadTimeout?: cdk.Duration;
    /**
     * (experimental) The SSL versions to use when interacting with the origin.
     *
     * @default OriginSslPolicy.TLS_V1_2
     * @experimental
     */
    readonly allowedOriginSSLVersions?: OriginSslPolicy[];
    /**
     * (experimental) The relative path to the origin root to use for sources.
     *
     * @default /
     * @experimental
     */
    readonly originPath?: string;
    /**
     * (experimental) Any additional headers to pass to the origin.
     *
     * @default - No additional headers are passed.
     * @experimental
     */
    readonly originHeaders?: {
        [key: string]: string;
    };
}
/**
 * @experimental
 */
export declare enum OriginSslPolicy {
    /**
     * @experimental
     */
    SSL_V3 = "SSLv3",
    /**
     * @experimental
     */
    TLS_V1 = "TLSv1",
    /**
     * @experimental
     */
    TLS_V1_1 = "TLSv1.1",
    /**
     * @experimental
     */
    TLS_V1_2 = "TLSv1.2"
}
/**
 * (experimental) S3 origin configuration for CloudFront.
 *
 * @experimental
 */
export interface S3OriginConfig {
    /**
     * (experimental) The source bucket to serve content from.
     *
     * @experimental
     */
    readonly s3BucketSource: s3.IBucket;
    /**
     * (experimental) The optional Origin Access Identity of the origin identity cloudfront will use when calling your s3 bucket.
     *
     * @default No Origin Access Identity which requires the S3 bucket to be public accessible
     * @experimental
     */
    readonly originAccessIdentity?: IOriginAccessIdentity;
    /**
     * (experimental) The relative path to the origin root to use for sources.
     *
     * @default /
     * @experimental
     */
    readonly originPath?: string;
    /**
     * (experimental) Any additional headers to pass to the origin.
     *
     * @default - No additional headers are passed.
     * @experimental
     */
    readonly originHeaders?: {
        [key: string]: string;
    };
}
/**
 * (experimental) An enum for the supported methods to a CloudFront distribution.
 *
 * @experimental
 */
export declare enum CloudFrontAllowedMethods {
    /**
     * @experimental
     */
    GET_HEAD = "GH",
    /**
     * @experimental
     */
    GET_HEAD_OPTIONS = "GHO",
    /**
     * @experimental
     */
    ALL = "ALL"
}
/**
 * (experimental) Enums for the methods CloudFront can cache.
 *
 * @experimental
 */
export declare enum CloudFrontAllowedCachedMethods {
    /**
     * @experimental
     */
    GET_HEAD = "GH",
    /**
     * @experimental
     */
    GET_HEAD_OPTIONS = "GHO"
}
/**
 * (experimental) A CloudFront behavior wrapper.
 *
 * @experimental
 */
export interface Behavior {
    /**
     * (experimental) If CloudFront should automatically compress some content types.
     *
     * @default true
     * @experimental
     */
    readonly compress?: boolean;
    /**
     * (experimental) If this behavior is the default behavior for the distribution.
     *
     * You must specify exactly one default distribution per CloudFront distribution.
     * The default behavior is allowed to omit the "path" property.
     *
     * @experimental
     */
    readonly isDefaultBehavior?: boolean;
    /**
     * (deprecated) Trusted signers is how CloudFront allows you to serve private content.
     *
     * The signers are the account IDs that are allowed to sign cookies/presigned URLs for this distribution.
     *
     * If you pass a non empty value, all requests for this behavior must be signed (no public access will be allowed)
     *
     * @deprecated - We recommend using trustedKeyGroups instead of trustedSigners.
     */
    readonly trustedSigners?: string[];
    /**
     * (experimental) A list of Key Groups that CloudFront can use to validate signed URLs or signed cookies.
     *
     * @default - no KeyGroups are associated with cache behavior
     * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
     * @experimental
     */
    readonly trustedKeyGroups?: IKeyGroup[];
    /**
     * (experimental) The default amount of time CloudFront will cache an object.
     *
     * This value applies only when your custom origin does not add HTTP headers,
     * such as Cache-Control max-age, Cache-Control s-maxage, and Expires to objects.
     *
     * @default 86400 (1 day)
     * @experimental
     */
    readonly defaultTtl?: cdk.Duration;
    /**
     * (experimental) The method this CloudFront distribution responds do.
     *
     * @default GET_HEAD
     * @experimental
     */
    readonly allowedMethods?: CloudFrontAllowedMethods;
    /**
     * (experimental) The path this behavior responds to.
     *
     * Required for all non-default behaviors. (The default behavior implicitly has "*" as the path pattern. )
     *
     * @experimental
     */
    readonly pathPattern?: string;
    /**
     * (experimental) Which methods are cached by CloudFront by default.
     *
     * @default GET_HEAD
     * @experimental
     */
    readonly cachedMethods?: CloudFrontAllowedCachedMethods;
    /**
     * (experimental) The values CloudFront will forward to the origin when making a request.
     *
     * @default none (no cookies - no headers)
     * @experimental
     */
    readonly forwardedValues?: CfnDistribution.ForwardedValuesProperty;
    /**
     * (experimental) The minimum amount of time that you want objects to stay in the cache before CloudFront queries your origin.
     *
     * @experimental
     */
    readonly minTtl?: cdk.Duration;
    /**
     * (experimental) The max amount of time you want objects to stay in the cache before CloudFront queries your origin.
     *
     * @default Duration.seconds(31536000) (one year)
     * @experimental
     */
    readonly maxTtl?: cdk.Duration;
    /**
     * (experimental) Declares associated lambda@edge functions for this distribution behaviour.
     *
     * @default No lambda function associated
     * @experimental
     */
    readonly lambdaFunctionAssociations?: LambdaFunctionAssociation[];
}
/**
 * @experimental
 */
export interface LambdaFunctionAssociation {
    /**
     * (experimental) The lambda event type defines at which event the lambda is called during the request lifecycle.
     *
     * @experimental
     */
    readonly eventType: LambdaEdgeEventType;
    /**
     * (experimental) A version of the lambda to associate.
     *
     * @experimental
     */
    readonly lambdaFunction: lambda.IVersion;
    /**
     * (experimental) Allows a Lambda function to have read access to the body content.
     *
     * Only valid for "request" event types (`ORIGIN_REQUEST` or `VIEWER_REQUEST`).
     * See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html
     *
     * @default false
     * @experimental
     */
    readonly includeBody?: boolean;
}
/**
 * @experimental
 */
export interface ViewerCertificateOptions {
    /**
     * (experimental) How CloudFront should serve HTTPS requests.
     *
     * See the notes on SSLMethod if you wish to use other SSL termination types.
     *
     * @default SSLMethod.SNI
     * @see https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ViewerCertificate.html
     * @experimental
     */
    readonly sslMethod?: SSLMethod;
    /**
     * (experimental) The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
     *
     * CloudFront serves your objects only to browsers or devices that support at
     * least the SSL version that you specify.
     *
     * @default - SSLv3 if sslMethod VIP, TLSv1 if sslMethod SNI
     * @experimental
     */
    readonly securityPolicy?: SecurityPolicyProtocol;
    /**
     * (experimental) Domain names on the certificate (both main domain name and Subject Alternative names).
     *
     * @experimental
     */
    readonly aliases?: string[];
}
/**
 * (experimental) Viewer certificate configuration class.
 *
 * @experimental
 */
export declare class ViewerCertificate {
    readonly props: CfnDistribution.ViewerCertificateProperty;
    readonly aliases: string[];
    /**
     * (experimental) Generate an AWS Certificate Manager (ACM) viewer certificate configuration.
     *
     * @param certificate AWS Certificate Manager (ACM) certificate.
     * @param options certificate configuration options.
     * @experimental
     */
    static fromAcmCertificate(certificate: certificatemanager.ICertificate, options?: ViewerCertificateOptions): ViewerCertificate;
    /**
     * (experimental) Generate an IAM viewer certificate configuration.
     *
     * @param iamCertificateId Identifier of the IAM certificate.
     * @param options certificate configuration options.
     * @experimental
     */
    static fromIamCertificate(iamCertificateId: string, options?: ViewerCertificateOptions): ViewerCertificate;
    /**
     * (experimental) Generate a viewer certifcate configuration using the CloudFront default certificate (e.g. d111111abcdef8.cloudfront.net) and a {@link SecurityPolicyProtocol.TLS_V1} security policy.
     *
     * @param aliases Alternative CNAME aliases You also must create a CNAME record with your DNS service to route queries.
     * @experimental
     */
    static fromCloudFrontDefaultCertificate(...aliases: string[]): ViewerCertificate;
    private constructor();
}
/**
 * @experimental
 */
export interface CloudFrontWebDistributionProps {
    /**
     * (deprecated) AliasConfiguration is used to configured CloudFront to respond to requests on custom domain names.
     *
     * @default - None.
     * @deprecated see {@link CloudFrontWebDistributionProps#viewerCertificate} with {@link ViewerCertificate#acmCertificate}
     */
    readonly aliasConfiguration?: AliasConfiguration;
    /**
     * (experimental) A comment for this distribution in the CloudFront console.
     *
     * @default - No comment is added to distribution.
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) The default object to serve.
     *
     * @default - "index.html" is served.
     * @experimental
     */
    readonly defaultRootObject?: string;
    /**
     * (experimental) If your distribution should have IPv6 enabled.
     *
     * @default true
     * @experimental
     */
    readonly enableIpV6?: boolean;
    /**
     * (experimental) The max supported HTTP Versions.
     *
     * @default HttpVersion.HTTP2
     * @experimental
     */
    readonly httpVersion?: HttpVersion;
    /**
     * (experimental) The price class for the distribution (this impacts how many locations CloudFront uses for your distribution, and billing).
     *
     * @default PriceClass.PRICE_CLASS_100 the cheapest option for CloudFront is picked by default.
     * @experimental
     */
    readonly priceClass?: PriceClass;
    /**
     * (experimental) The default viewer policy for incoming clients.
     *
     * @default RedirectToHTTPs
     * @experimental
     */
    readonly viewerProtocolPolicy?: ViewerProtocolPolicy;
    /**
     * (experimental) The origin configurations for this distribution.
     *
     * Behaviors are a part of the origin.
     *
     * @experimental
     */
    readonly originConfigs: SourceConfiguration[];
    /**
     * (experimental) Optional - if we should enable logging.
     *
     * You can pass an empty object ({}) to have us auto create a bucket for logging.
     * Omission of this property indicates no logging is to be enabled.
     *
     * @default - no logging is enabled by default.
     * @experimental
     */
    readonly loggingConfig?: LoggingConfiguration;
    /**
     * (experimental) How CloudFront should handle requests that are not successful (eg PageNotFound).
     *
     * By default, CloudFront does not replace HTTP status codes in the 4xx and 5xx range
     * with custom error messages. CloudFront does not cache HTTP status codes.
     *
     * @default - No custom error configuration.
     * @experimental
     */
    readonly errorConfigurations?: CfnDistribution.CustomErrorResponseProperty[];
    /**
     * (experimental) Unique identifier that specifies the AWS WAF web ACL to associate with this CloudFront distribution.
     *
     * To specify a web ACL created using the latest version of AWS WAF, use the ACL ARN, for example
     * `arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a`.
     *
     * To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `473e64fd-f30b-4765-81a0-62ad96dd167a`.
     *
     * @default - No AWS Web Application Firewall web access control list (web ACL).
     * @see https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html#API_CreateDistribution_RequestParameters.
     * @experimental
     */
    readonly webACLId?: string;
    /**
     * (experimental) Specifies whether you want viewers to use HTTP or HTTPS to request your objects, whether you're using an alternate domain name with HTTPS, and if so, if you're using AWS Certificate Manager (ACM) or a third-party certificate authority.
     *
     * @default ViewerCertificate.fromCloudFrontDefaultCertificate()
     * @see https://aws.amazon.com/premiumsupport/knowledge-center/custom-ssl-certificate-cloudfront/
     * @experimental
     */
    readonly viewerCertificate?: ViewerCertificate;
    /**
     * (experimental) Controls the countries in which your content is distributed.
     *
     * @default No geo restriction
     * @experimental
     */
    readonly geoRestriction?: GeoRestriction;
}
/**
 * (experimental) Attributes used to import a Distribution.
 *
 * @experimental
 */
export interface CloudFrontWebDistributionAttributes {
    /**
     * (experimental) The generated domain name of the Distribution, such as d111111abcdef8.cloudfront.net.
     *
     * @experimental
     * @attribute true
     */
    readonly domainName: string;
    /**
     * (experimental) The distribution ID for this distribution.
     *
     * @experimental
     * @attribute true
     */
    readonly distributionId: string;
}
/**
 * (experimental) Amazon CloudFront is a global content delivery network (CDN) service that securely delivers data, videos, applications, and APIs to your viewers with low latency and high transfer speeds.
 *
 * CloudFront fronts user provided content and caches it at edge locations across the world.
 *
 * Here's how you can use this construct:
 *
 * ```ts
 * import { CloudFrontWebDistribution } from '@aws-cdk/aws-cloudfront'
 *
 * const sourceBucket = new Bucket(this, 'Bucket');
 *
 * const distribution = new CloudFrontWebDistribution(this, 'MyDistribution', {
 *   originConfigs: [
 *     {
 *       s3OriginSource: {
 *       s3BucketSource: sourceBucket
 *       },
 *       behaviors : [ {isDefaultBehavior: true}]
 *     }
 *   ]
 * });
 * ```
 *
 * This will create a CloudFront distribution that uses your S3Bucket as it's origin.
 *
 * You can customize the distribution using additional properties from the CloudFrontWebDistributionProps interface.
 *
 * @experimental
 * @resource AWS::CloudFront::Distribution
 */
export declare class CloudFrontWebDistribution extends cdk.Resource implements IDistribution {
    /**
     * (experimental) Creates a construct that represents an external (imported) distribution.
     *
     * @experimental
     */
    static fromDistributionAttributes(scope: Construct, id: string, attrs: CloudFrontWebDistributionAttributes): IDistribution;
    /**
     * (experimental) The logging bucket for this CloudFront distribution.
     *
     * If logging is not enabled for this distribution - this property will be undefined.
     *
     * @experimental
     */
    readonly loggingBucket?: s3.IBucket;
    /**
     * (deprecated) The domain name created by CloudFront for this distribution.
     *
     * If you are using aliases for your distribution, this is the domainName your DNS records should point to.
     * (In Route53, you could create an ALIAS record to this value, for example.)
     *
     * @deprecated - Use `distributionDomainName` instead.
     */
    readonly domainName: string;
    /**
     * (experimental) The domain name created by CloudFront for this distribution.
     *
     * If you are using aliases for your distribution, this is the domainName your DNS records should point to.
     * (In Route53, you could create an ALIAS record to this value, for example.)
     *
     * @experimental
     */
    readonly distributionDomainName: string;
    /**
     * (experimental) The distribution ID for this distribution.
     *
     * @experimental
     */
    readonly distributionId: string;
    /**
     * Maps our methods to the string arrays they are
     */
    private readonly METHOD_LOOKUP_MAP;
    /**
     * Maps for which SecurityPolicyProtocol are available to which SSLMethods
     */
    private readonly VALID_SSL_PROTOCOLS;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CloudFrontWebDistributionProps);
    private toBehavior;
    private toOriginProperty;
}
