import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Represents a Public Key.
 *
 * @experimental
 */
export interface IPublicKey extends IResource {
    /**
     * (experimental) The ID of the key group.
     *
     * @experimental
     * @attribute true
     */
    readonly publicKeyId: string;
}
/**
 * (experimental) Properties for creating a Public Key.
 *
 * @experimental
 */
export interface PublicKeyProps {
    /**
     * (experimental) A name to identify the public key.
     *
     * @default - generated from the `id`
     * @experimental
     */
    readonly publicKeyName?: string;
    /**
     * (experimental) A comment to describe the public key.
     *
     * @default - no comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) The public key that you can use with signed URLs and signed cookies, or with field-level encryption.
     *
     * The `encodedKey` parameter must include `-----BEGIN PUBLIC KEY-----` and `-----END PUBLIC KEY-----` lines.
     *
     * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html
     * @experimental
     */
    readonly encodedKey: string;
}
/**
 * (experimental) A Public Key Configuration.
 *
 * @experimental
 * @resource AWS::CloudFront::PublicKey
 */
export declare class PublicKey extends Resource implements IPublicKey {
    /**
     * (experimental) Imports a Public Key from its id.
     *
     * @experimental
     */
    static fromPublicKeyId(scope: Construct, id: string, publicKeyId: string): IPublicKey;
    /**
     * (experimental) The ID of the key group.
     *
     * @experimental
     */
    readonly publicKeyId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PublicKeyProps);
    private generateName;
}
