import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IPublicKey } from './public-key';
/**
 * (experimental) Represents a Key Group.
 *
 * @experimental
 */
export interface IKeyGroup extends IResource {
    /**
     * (experimental) The ID of the key group.
     *
     * @experimental
     * @attribute true
     */
    readonly keyGroupId: string;
}
/**
 * (experimental) Properties for creating a Public Key.
 *
 * @experimental
 */
export interface KeyGroupProps {
    /**
     * (experimental) A name to identify the key group.
     *
     * @default - generated from the `id`
     * @experimental
     */
    readonly keyGroupName?: string;
    /**
     * (experimental) A comment to describe the key group.
     *
     * @default - no comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) A list of public keys to add to the key group.
     *
     * @experimental
     */
    readonly items: IPublicKey[];
}
/**
 * (experimental) A Key Group configuration.
 *
 * @experimental
 * @resource AWS::CloudFront::KeyGroup
 */
export declare class KeyGroup extends Resource implements IKeyGroup {
    /**
     * (experimental) Imports a Key Group from its id.
     *
     * @experimental
     */
    static fromKeyGroupId(scope: Construct, id: string, keyGroupId: string): IKeyGroup;
    /**
     * (experimental) The ID of the key group.
     *
     * @experimental
     */
    readonly keyGroupId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KeyGroupProps);
    private generateName;
}
