import * as acm from "../../aws-certificatemanager";
import * as lambda from "../../aws-lambda";
import * as s3 from "../../aws-s3";
import { IResource, Resource, Duration } from "../../core";
import { Construct } from 'constructs';
import { ICachePolicy } from './cache-policy';
import { GeoRestriction } from './geo-restriction';
import { IKeyGroup } from './key-group';
import { IOrigin } from './origin';
import { IOriginRequestPolicy } from './origin-request-policy';
/**
 * (experimental) Interface for CloudFront distributions.
 *
 * @experimental
 */
export interface IDistribution extends IResource {
    /**
     * (deprecated) The domain name of the Distribution, such as d111111abcdef8.cloudfront.net.
     *
     * @deprecated - Use `distributionDomainName` instead.
     * @attribute true
     */
    readonly domainName: string;
    /**
     * (experimental) The domain name of the Distribution, such as d111111abcdef8.cloudfront.net.
     *
     * @experimental
     * @attribute true
     */
    readonly distributionDomainName: string;
    /**
     * (experimental) The distribution ID for this distribution.
     *
     * @experimental
     * @attribute true
     */
    readonly distributionId: string;
}
/**
 * (experimental) Attributes used to import a Distribution.
 *
 * @experimental
 */
export interface DistributionAttributes {
    /**
     * (experimental) The generated domain name of the Distribution, such as d111111abcdef8.cloudfront.net.
     *
     * @experimental
     * @attribute true
     */
    readonly domainName: string;
    /**
     * (experimental) The distribution ID for this distribution.
     *
     * @experimental
     * @attribute true
     */
    readonly distributionId: string;
}
/**
 * (experimental) Properties for a Distribution.
 *
 * @experimental
 */
export interface DistributionProps {
    /**
     * (experimental) The default behavior for the distribution.
     *
     * @experimental
     */
    readonly defaultBehavior: BehaviorOptions;
    /**
     * (experimental) Additional behaviors for the distribution, mapped by the pathPattern that specifies which requests to apply the behavior to.
     *
     * @default - no additional behaviors are added.
     * @experimental
     */
    readonly additionalBehaviors?: Record<string, BehaviorOptions>;
    /**
     * (experimental) A certificate to associate with the distribution.
     *
     * The certificate must be located in N. Virginia (us-east-1).
     *
     * @default - the CloudFront wildcard certificate (*.cloudfront.net) will be used.
     * @experimental
     */
    readonly certificate?: acm.ICertificate;
    /**
     * (experimental) Any comments you want to include about the distribution.
     *
     * @default - no comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) The object that you want CloudFront to request from your origin (for example, index.html) when a viewer requests the root URL for your distribution. If no default object is set, the request goes to the origin's root (e.g., example.com/).
     *
     * @default - no default root object
     * @experimental
     */
    readonly defaultRootObject?: string;
    /**
     * (experimental) Alternative domain names for this distribution.
     *
     * If you want to use your own domain name, such as www.example.com, instead of the cloudfront.net domain name,
     * you can add an alternate domain name to your distribution. If you attach a certificate to the distribution,
     * you must add (at least one of) the domain names of the certificate to this list.
     *
     * @default - The distribution will only support the default generated name (e.g., d111111abcdef8.cloudfront.net)
     * @experimental
     */
    readonly domainNames?: string[];
    /**
     * (experimental) Enable or disable the distribution.
     *
     * @default true
     * @experimental
     */
    readonly enabled?: boolean;
    /**
     * (experimental) Whether CloudFront will respond to IPv6 DNS requests with an IPv6 address.
     *
     * If you specify false, CloudFront responds to IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
     * This allows viewers to submit a second request, for an IPv4 address for your distribution.
     *
     * @default true
     * @experimental
     */
    readonly enableIpv6?: boolean;
    /**
     * (experimental) Enable access logging for the distribution.
     *
     * @default - false, unless `logBucket` is specified.
     * @experimental
     */
    readonly enableLogging?: boolean;
    /**
     * (experimental) Controls the countries in which your content is distributed.
     *
     * @default - No geographic restrictions
     * @experimental
     */
    readonly geoRestriction?: GeoRestriction;
    /**
     * (experimental) Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront.
     *
     * For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support server name identification (SNI).
     *
     * @default HttpVersion.HTTP2
     * @experimental
     */
    readonly httpVersion?: HttpVersion;
    /**
     * (experimental) The Amazon S3 bucket to store the access logs in.
     *
     * @default - A bucket is created if `enableLogging` is true
     * @experimental
     */
    readonly logBucket?: s3.IBucket;
    /**
     * (experimental) Specifies whether you want CloudFront to include cookies in access logs.
     *
     * @default false
     * @experimental
     */
    readonly logIncludesCookies?: boolean;
    /**
     * (experimental) An optional string that you want CloudFront to prefix to the access log filenames for this distribution.
     *
     * @default - no prefix
     * @experimental
     */
    readonly logFilePrefix?: string;
    /**
     * (experimental) The price class that corresponds with the maximum price that you want to pay for CloudFront service.
     *
     * If you specify PriceClass_All, CloudFront responds to requests for your objects from all CloudFront edge locations.
     * If you specify a price class other than PriceClass_All, CloudFront serves your objects from the CloudFront edge location
     * that has the lowest latency among the edge locations in your price class.
     *
     * @default PriceClass.PRICE_CLASS_ALL
     * @experimental
     */
    readonly priceClass?: PriceClass;
    /**
     * (experimental) Unique identifier that specifies the AWS WAF web ACL to associate with this CloudFront distribution.
     *
     * To specify a web ACL created using the latest version of AWS WAF, use the ACL ARN, for example
     * `arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a`.
     * To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `473e64fd-f30b-4765-81a0-62ad96dd167a`.
     *
     * @default - No AWS Web Application Firewall web access control list (web ACL).
     * @see https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html#API_CreateDistribution_RequestParameters.
     * @experimental
     */
    readonly webAclId?: string;
    /**
     * (experimental) How CloudFront should handle requests that are not successful (e.g., PageNotFound).
     *
     * @default - No custom error responses.
     * @experimental
     */
    readonly errorResponses?: ErrorResponse[];
    /**
     * (experimental) The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
     *
     * CloudFront serves your objects only to browsers or devices that support at
     * least the SSL version that you specify.
     *
     * @default SecurityPolicyProtocol.TLS_V1_2_2019
     * @experimental
     */
    readonly minimumProtocolVersion?: SecurityPolicyProtocol;
}
/**
 * (experimental) A CloudFront distribution with associated origin(s) and caching behavior(s).
 *
 * @experimental
 */
export declare class Distribution extends Resource implements IDistribution {
    /**
     * (experimental) Creates a Distribution construct that represents an external (imported) distribution.
     *
     * @experimental
     */
    static fromDistributionAttributes(scope: Construct, id: string, attrs: DistributionAttributes): IDistribution;
    /**
     * (experimental) The domain name of the Distribution, such as d111111abcdef8.cloudfront.net.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) The domain name of the Distribution, such as d111111abcdef8.cloudfront.net.
     *
     * @experimental
     */
    readonly distributionDomainName: string;
    /**
     * (experimental) The distribution ID for this distribution.
     *
     * @experimental
     */
    readonly distributionId: string;
    private readonly defaultBehavior;
    private readonly additionalBehaviors;
    private readonly boundOrigins;
    private readonly originGroups;
    private readonly errorResponses;
    private readonly certificate?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DistributionProps);
    /**
     * (experimental) Adds a new behavior to this distribution for the given pathPattern.
     *
     * @param pathPattern the path pattern (e.g., 'images/*') that specifies which requests to apply the behavior to.
     * @param origin the origin to use for this behavior.
     * @param behaviorOptions the options for the behavior at this path.
     * @experimental
     */
    addBehavior(pathPattern: string, origin: IOrigin, behaviorOptions?: AddBehaviorOptions): void;
    private addOrigin;
    private addOriginGroup;
    private renderOrigins;
    private renderOriginGroups;
    private renderCacheBehaviors;
    private renderErrorResponses;
    private renderLogging;
    private renderRestrictions;
    private renderViewerCertificate;
}
/**
 * (experimental) Maximum HTTP version to support.
 *
 * @experimental
 */
export declare enum HttpVersion {
    /**
     * (experimental) HTTP 1.1.
     *
     * @experimental
     */
    HTTP1_1 = "http1.1",
    /**
     * (experimental) HTTP 2.
     *
     * @experimental
     */
    HTTP2 = "http2"
}
/**
 * (experimental) The price class determines how many edge locations CloudFront will use for your distribution.
 *
 * See https://aws.amazon.com/cloudfront/pricing/ for full list of supported regions.
 *
 * @experimental
 */
export declare enum PriceClass {
    /**
     * (experimental) USA, Canada, Europe, & Israel.
     *
     * @experimental
     */
    PRICE_CLASS_100 = "PriceClass_100",
    /**
     * (experimental) PRICE_CLASS_100 + South Africa, Kenya, Middle East, Japan, Singapore, South Korea, Taiwan, Hong Kong, & Philippines.
     *
     * @experimental
     */
    PRICE_CLASS_200 = "PriceClass_200",
    /**
     * (experimental) All locations.
     *
     * @experimental
     */
    PRICE_CLASS_ALL = "PriceClass_All"
}
/**
 * (experimental) How HTTPs should be handled with your distribution.
 *
 * @experimental
 */
export declare enum ViewerProtocolPolicy {
    /**
     * (experimental) HTTPS only.
     *
     * @experimental
     */
    HTTPS_ONLY = "https-only",
    /**
     * (experimental) Will redirect HTTP requests to HTTPS.
     *
     * @experimental
     */
    REDIRECT_TO_HTTPS = "redirect-to-https",
    /**
     * (experimental) Both HTTP and HTTPS supported.
     *
     * @experimental
     */
    ALLOW_ALL = "allow-all"
}
/**
 * (experimental) Defines what protocols CloudFront will use to connect to an origin.
 *
 * @experimental
 */
export declare enum OriginProtocolPolicy {
    /**
     * (experimental) Connect on HTTP only.
     *
     * @experimental
     */
    HTTP_ONLY = "http-only",
    /**
     * (experimental) Connect with the same protocol as the viewer.
     *
     * @experimental
     */
    MATCH_VIEWER = "match-viewer",
    /**
     * (experimental) Connect on HTTPS only.
     *
     * @experimental
     */
    HTTPS_ONLY = "https-only"
}
/**
 * (experimental) The SSL method CloudFront will use for your distribution.
 *
 * Server Name Indication (SNI) - is an extension to the TLS computer networking protocol by which a client indicates
 *   which hostname it is attempting to connect to at the start of the handshaking process. This allows a server to present
 *   multiple certificates on the same IP address and TCP port number and hence allows multiple secure (HTTPS) websites
 * (or any other service over TLS) to be served by the same IP address without requiring all those sites to use the same certificate.
 *
 * CloudFront can use SNI to host multiple distributions on the same IP - which a large majority of clients will support.
 *
 * If your clients cannot support SNI however - CloudFront can use dedicated IPs for your distribution - but there is a prorated monthly charge for
 * using this feature. By default, we use SNI - but you can optionally enable dedicated IPs (VIP).
 *
 * See the CloudFront SSL for more details about pricing : https://aws.amazon.com/cloudfront/custom-ssl-domains/
 *
 * @experimental
 */
export declare enum SSLMethod {
    /**
     * @experimental
     */
    SNI = "sni-only",
    /**
     * @experimental
     */
    VIP = "vip"
}
/**
 * (experimental) The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
 *
 * CloudFront serves your objects only to browsers or devices that support at least the SSL version that you specify.
 *
 * @experimental
 */
export declare enum SecurityPolicyProtocol {
    /**
     * @experimental
     */
    SSL_V3 = "SSLv3",
    /**
     * @experimental
     */
    TLS_V1 = "TLSv1",
    /**
     * @experimental
     */
    TLS_V1_2016 = "TLSv1_2016",
    /**
     * @experimental
     */
    TLS_V1_1_2016 = "TLSv1.1_2016",
    /**
     * @experimental
     */
    TLS_V1_2_2018 = "TLSv1.2_2018",
    /**
     * @experimental
     */
    TLS_V1_2_2019 = "TLSv1.2_2019"
}
/**
 * (experimental) The HTTP methods that the Behavior will accept requests on.
 *
 * @experimental
 */
export declare class AllowedMethods {
    /**
     * (experimental) HEAD and GET.
     *
     * @experimental
     */
    static readonly ALLOW_GET_HEAD: AllowedMethods;
    /**
     * (experimental) HEAD, GET, and OPTIONS.
     *
     * @experimental
     */
    static readonly ALLOW_GET_HEAD_OPTIONS: AllowedMethods;
    /**
     * (experimental) All supported HTTP methods.
     *
     * @experimental
     */
    static readonly ALLOW_ALL: AllowedMethods;
    /**
     * (experimental) HTTP methods supported.
     *
     * @experimental
     */
    readonly methods: string[];
    private constructor();
}
/**
 * (experimental) The HTTP methods that the Behavior will cache requests on.
 *
 * @experimental
 */
export declare class CachedMethods {
    /**
     * (experimental) HEAD and GET.
     *
     * @experimental
     */
    static readonly CACHE_GET_HEAD: CachedMethods;
    /**
     * (experimental) HEAD, GET, and OPTIONS.
     *
     * @experimental
     */
    static readonly CACHE_GET_HEAD_OPTIONS: CachedMethods;
    /**
     * (experimental) HTTP methods supported.
     *
     * @experimental
     */
    readonly methods: string[];
    private constructor();
}
/**
 * (experimental) Options for configuring custom error responses.
 *
 * @experimental
 */
export interface ErrorResponse {
    /**
     * (experimental) The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in ErrorCode.
     *
     * @default - the default caching TTL behavior applies
     * @experimental
     */
    readonly ttl?: Duration;
    /**
     * (experimental) The HTTP status code for which you want to specify a custom error page and/or a caching duration.
     *
     * @experimental
     */
    readonly httpStatus: number;
    /**
     * (experimental) The HTTP status code that you want CloudFront to return to the viewer along with the custom error page.
     *
     * If you specify a value for `responseHttpStatus`, you must also specify a value for `responsePagePath`.
     *
     * @default - the error code will be returned as the response code.
     * @experimental
     */
    readonly responseHttpStatus?: number;
    /**
     * (experimental) The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the `httpStatus`, for example, /4xx-errors/403-forbidden.html.
     *
     * @default - the default CloudFront response is shown.
     * @experimental
     */
    readonly responsePagePath?: string;
}
/**
 * (experimental) The type of events that a Lambda@Edge function can be invoked in response to.
 *
 * @experimental
 */
export declare enum LambdaEdgeEventType {
    /**
     * (experimental) The origin-request specifies the request to the origin location (e.g. S3).
     *
     * @experimental
     */
    ORIGIN_REQUEST = "origin-request",
    /**
     * (experimental) The origin-response specifies the response from the origin location (e.g. S3).
     *
     * @experimental
     */
    ORIGIN_RESPONSE = "origin-response",
    /**
     * (experimental) The viewer-request specifies the incoming request.
     *
     * @experimental
     */
    VIEWER_REQUEST = "viewer-request",
    /**
     * (experimental) The viewer-response specifies the outgoing response.
     *
     * @experimental
     */
    VIEWER_RESPONSE = "viewer-response"
}
/**
 * (experimental) Represents a Lambda function version and event type when using Lambda@Edge.
 *
 * The type of the {@link AddBehaviorOptions.edgeLambdas} property.
 *
 * @experimental
 */
export interface EdgeLambda {
    /**
     * (experimental) The version of the Lambda function that will be invoked.
     *
     * **Note**: it's not possible to use the '$LATEST' function version for Lambda@Edge!
     *
     * @experimental
     */
    readonly functionVersion: lambda.IVersion;
    /**
     * (experimental) The type of event in response to which should the function be invoked.
     *
     * @experimental
     */
    readonly eventType: LambdaEdgeEventType;
    /**
     * (experimental) Allows a Lambda function to have read access to the body content.
     *
     * Only valid for "request" event types (`ORIGIN_REQUEST` or `VIEWER_REQUEST`).
     * See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html
     *
     * @default false
     * @experimental
     */
    readonly includeBody?: boolean;
}
/**
 * (experimental) Options for adding a new behavior to a Distribution.
 *
 * @experimental
 */
export interface AddBehaviorOptions {
    /**
     * (experimental) HTTP methods to allow for this behavior.
     *
     * @default AllowedMethods.ALLOW_GET_HEAD
     * @experimental
     */
    readonly allowedMethods?: AllowedMethods;
    /**
     * (experimental) HTTP methods to cache for this behavior.
     *
     * @default CachedMethods.CACHE_GET_HEAD
     * @experimental
     */
    readonly cachedMethods?: CachedMethods;
    /**
     * (experimental) The cache policy for this behavior.
     *
     * The cache policy determines what values are included in the cache key,
     * and the time-to-live (TTL) values for the cache.
     *
     * @default CachePolicy.CACHING_OPTIMIZED
     * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html.
     * @experimental
     */
    readonly cachePolicy?: ICachePolicy;
    /**
     * (experimental) Whether you want CloudFront to automatically compress certain files for this cache behavior.
     *
     * See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html#compressed-content-cloudfront-file-types
     * for file types CloudFront will compress.
     *
     * @default true
     * @experimental
     */
    readonly compress?: boolean;
    /**
     * (experimental) The origin request policy for this behavior.
     *
     * The origin request policy determines which values (e.g., headers, cookies)
     * are included in requests that CloudFront sends to the origin.
     *
     * @default - none
     * @experimental
     */
    readonly originRequestPolicy?: IOriginRequestPolicy;
    /**
     * (experimental) Set this to true to indicate you want to distribute media files in the Microsoft Smooth Streaming format using this behavior.
     *
     * @default false
     * @experimental
     */
    readonly smoothStreaming?: boolean;
    /**
     * (experimental) The protocol that viewers can use to access the files controlled by this behavior.
     *
     * @default ViewerProtocolPolicy.ALLOW_ALL
     * @experimental
     */
    readonly viewerProtocolPolicy?: ViewerProtocolPolicy;
    /**
     * (experimental) The Lambda@Edge functions to invoke before serving the contents.
     *
     * @default - no Lambda functions will be invoked
     * @see https://aws.amazon.com/lambda/edge
     * @experimental
     */
    readonly edgeLambdas?: EdgeLambda[];
    /**
     * (experimental) A list of Key Groups that CloudFront can use to validate signed URLs or signed cookies.
     *
     * @default - no KeyGroups are associated with cache behavior
     * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html
     * @experimental
     */
    readonly trustedKeyGroups?: IKeyGroup[];
}
/**
 * (experimental) Options for creating a new behavior.
 *
 * @experimental
 */
export interface BehaviorOptions extends AddBehaviorOptions {
    /**
     * (experimental) The origin that you want CloudFront to route requests to when they match this behavior.
     *
     * @experimental
     */
    readonly origin: IOrigin;
}
