"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class CloudFrontMetrics {
    static requestsSum(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: 'Requests',
            dimensions,
            statistic: 'Sum',
        };
    }
    static totalErrorRateAverage(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: 'TotalErrorRate',
            dimensions,
            statistic: 'Average',
        };
    }
    static bytesDownloadedSum(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: 'BytesDownloaded',
            dimensions,
            statistic: 'Sum',
        };
    }
    static bytesUploadedAverage(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: 'BytesUploaded',
            dimensions,
            statistic: 'Average',
        };
    }
    static _4XxErrorRateAverage(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: '4xxErrorRate',
            dimensions,
            statistic: 'Average',
        };
    }
    static _5XxErrorRateAverage(dimensions) {
        return {
            namespace: 'AWS/CloudFront',
            metricName: '5xxErrorRate',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.CloudFrontMetrics = CloudFrontMetrics;
//# sourceMappingURL=data:application/json;base64,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