"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) An Origin that represents a group.
 *
 * Consists of a primary Origin,
 * and a fallback Origin called when the primary returns one of the provided HTTP status codes.
 *
 * @experimental
 */
class OriginGroup {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) The method called when a given Origin is added (for the first time) to a Distribution.
     *
     * @experimental
     */
    bind(scope, options) {
        const primaryOriginConfig = this.props.primaryOrigin.bind(scope, options);
        if (primaryOriginConfig.failoverConfig) {
            throw new Error('An OriginGroup cannot use an Origin with its own failover configuration as its primary origin!');
        }
        return {
            originProperty: primaryOriginConfig.originProperty,
            failoverConfig: {
                failoverOrigin: this.props.fallbackOrigin,
                statusCodes: this.props.fallbackStatusCodes,
            },
        };
    }
}
exports.OriginGroup = OriginGroup;
_a = JSII_RTTI_SYMBOL_1;
OriginGroup[_a] = { fqn: "monocdk.aws_cloudfront_origins.OriginGroup", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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