import * as cloudfront from "../../aws-cloudfront";
import { Construct } from "../../core";
/**
 * (experimental) Construction properties for {@link OriginGroup}.
 *
 * @experimental
 */
export interface OriginGroupProps {
    /**
     * (experimental) The primary origin that should serve requests for this group.
     *
     * @experimental
     */
    readonly primaryOrigin: cloudfront.IOrigin;
    /**
     * (experimental) The fallback origin that should serve requests when the primary fails.
     *
     * @experimental
     */
    readonly fallbackOrigin: cloudfront.IOrigin;
    /**
     * (experimental) The list of HTTP status codes that, when returned from the primary origin, would cause querying the fallback origin.
     *
     * @default - 500, 502, 503 and 504
     * @experimental
     */
    readonly fallbackStatusCodes?: number[];
}
/**
 * (experimental) An Origin that represents a group.
 *
 * Consists of a primary Origin,
 * and a fallback Origin called when the primary returns one of the provided HTTP status codes.
 *
 * @experimental
 */
export declare class OriginGroup implements cloudfront.IOrigin {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: OriginGroupProps);
    /**
     * (experimental) The method called when a given Origin is added (for the first time) to a Distribution.
     *
     * @experimental
     */
    bind(scope: Construct, options: cloudfront.OriginBindOptions): cloudfront.OriginBindConfig;
}
